// 2004.05.28, 2004.10.20, 2005.01.08, 2005.03.25, 2005.04.28, 2005.07.18, 2005.07.28, 2005.09.19
//****************************************
//**  Copyright  (C)  W.ch  1999-2005   **
//**  Web:  http://www.winchiphead.com  **
//****************************************
//**  DLL for USB interface chip CH341  **
//**  C, VC5.0                          **
//****************************************
//
// USB߽ӿоƬCH341Ӧòӿڿ V1.9
// Ͼߺ޹˾  : W.ch 2005.09
// CH341-DLL  V1.9
// л: Windows 98/ME, Windows 2000/XP
// support USB chip: CH341, CH341A
// USB => Parallel, I2C, SPI, JTAG ...
//

#ifndef		_CH341_DLL_H
#define		_CH341_DLL_H

#ifdef __cplusplus
extern "C" {
#endif

#define		mOFFSET( s, m )			( (ULONG) & ( ( ( s * ) 0 ) -> m ) )	// ȡṹԱƫƵַĺ

#ifndef		max
#define		max( a, b )				( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )	// ϴֵ
#endif

#ifndef		min
#define		min( a, b )				( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )	// Сֵ
#endif

#ifdef		ExAllocatePool
#undef		ExAllocatePool						// ɾTAGڴ
#endif

#ifndef		NTSTATUS
typedef		LONG	NTSTATUS;					// ״̬
#endif


typedef	struct	_USB_SETUP_PKT {				// USBƴĽ׶εṹ
	UCHAR			mUspReqType;				// 00H 
	UCHAR			mUspRequest;				// 01H 
	union	{
		struct	{
			UCHAR	mUspValueLow;				// 02H ֵֽ
			UCHAR	mUspValueHigh;				// 03H ֵֽ
		};
		USHORT		mUspValue;					// 02H-03H ֵ
	};
	union	{
		struct	{
			UCHAR	mUspIndexLow;				// 04H ֽ
			UCHAR	mUspIndexHigh;				// 05H ֽ
		};
		USHORT		mUspIndex;					// 04H-05H 
	};
	USHORT			mLength;					// 06H-07H ݽ׶εݳ
} mUSB_SETUP_PKT, *mPUSB_SETUP_PKT;


#define		mCH341_PACKET_LENGTH	32			// CH341ֵ֧ݰĳ
#define		mCH341_PKT_LEN_SHORT	8			// CH341ֵ֧Ķݰĳ


typedef	struct	_WIN32_COMMAND {				// WIN32ӿڽṹ
	union	{
		ULONG		mFunction;					// ʱָܴ߹ܵ
		NTSTATUS	mStatus;					// ʱز״̬
	};
	ULONG			mLength;					// ȡ,غݵĳ
	union	{
		mUSB_SETUP_PKT	mSetupPkt;				// USBƴĽ׶ε
		UCHAR			mBuffer[ mCH341_PACKET_LENGTH ];	// ݻ,Ϊ0255B
	};
} mWIN32_COMMAND, *mPWIN32_COMMAND;


// WIN32Ӧòӿ
#define		IOCTL_CH341_COMMAND		( FILE_DEVICE_UNKNOWN << 16 | FILE_ANY_ACCESS << 14 | 0x0f34 << 2 | METHOD_BUFFERED )	// רýӿ

#define		mWIN32_COMMAND_HEAD		mOFFSET( mWIN32_COMMAND, mBuffer )	// WIN32ӿڵͷ

#define		mCH341_MAX_NUMBER		16			// ͬʱӵCH341

#define		mMAX_BUFFER_LENGTH		0x1000		// ݻ󳤶4096

#define		mMAX_COMMAND_LENGTH		( mWIN32_COMMAND_HEAD + mMAX_BUFFER_LENGTH )	// ݳȼṹͷĳ

#define		mDEFAULT_BUFFER_LEN		0x0400		// ݻĬϳ1024

#define		mDEFAULT_COMMAND_LEN	( mWIN32_COMMAND_HEAD + mDEFAULT_BUFFER_LEN )	// Ĭݳȼṹͷĳ


// CH341˵ַ
#define		mCH341_ENDP_INTER_UP	0x81		// CH341жϴ˵ĵַ
#define		mCH341_ENDP_INTER_DOWN	0x01		// CH341ж´˵ĵַ
#define		mCH341_ENDP_DATA_UP		0x82		// CH341ݿϴ˵ĵַ
#define		mCH341_ENDP_DATA_DOWN	0x02		// CH341ݿ´˵ĵַ


// 豸ӿṩĹܵ
#define		mPipeDeviceCtrl			0x00000004	// CH341ۺϿƹܵ
#define		mPipeInterUp			0x00000005	// CH341жϴܵ
#define		mPipeDataUp				0x00000006	// CH341ݿϴܵ
#define		mPipeDataDown			0x00000007	// CH341ݿ´ܵ

// ӦòӿڵĹܴ
#define		mFuncNoOperation		0x00000000	// ޲
#define		mFuncGetVersion			0x00000001	// ȡ汾
#define		mFuncGetConfig			0x00000002	// ȡUSB豸
#define		mFuncSetTimeout			0x00000009	// USBͨѶʱ
#define		mFuncSetExclusive		0x0000000b	// öռʹ
#define		mFuncResetDevice		0x0000000c	// λUSB豸
#define		mFuncResetPipe			0x0000000d	// λUSBܵ
#define		mFuncAbortPipe			0x0000000e	// ȡUSBܵ

// CH341רõĹܴ
#define		mFuncSetParaMode		0x0000000f	// òģʽ
#define		mFuncReadData0			0x00000010	// Ӳڶȡݿ0
#define		mFuncReadData1			0x00000011	// Ӳڶȡݿ1
#define		mFuncWriteData0			0x00000012	// 򲢿дݿ0
#define		mFuncWriteData1			0x00000013	// 򲢿дݿ1
#define		mFuncWriteRead			0x00000014	// 
#define		mFuncBufferMode			0x00000020	// 趨ϴģʽѯеݳ
#define		mFuncBufferModeDn		0x00000021	// 趨´ģʽѯеݳ


// USB豸׼
#define		mUSB_CLR_FEATURE		0x01
#define		mUSB_SET_FEATURE		0x03
#define		mUSB_GET_STATUS			0x00
#define		mUSB_SET_ADDRESS		0x05
#define		mUSB_GET_DESCR			0x06
#define		mUSB_SET_DESCR			0x07
#define		mUSB_GET_CONFIG			0x08
#define		mUSB_SET_CONFIG			0x09
#define		mUSB_GET_INTERF			0x0a
#define		mUSB_SET_INTERF			0x0b
#define		mUSB_SYNC_FRAME			0x0c

// CH341ƴĳר
#define		mCH341_VENDOR_READ		0xC0		// ͨƴʵֵCH341רö
#define		mCH341_VENDOR_WRITE		0x40		// ͨƴʵֵCH341רд

// CH341ƴĳר
#define		mCH341_PARA_INIT		0xB1		// ʼ
#define		mCH341_I2C_STATUS		0x52		// ȡI2Cӿڵ״̬
#define		mCH341_I2C_COMMAND		0x53		// I2Cӿڵ

// CH341ڲ
#define		mCH341_PARA_CMD_R0		0xAC		// Ӳڶ0
#define		mCH341_PARA_CMD_R1		0xAD		// Ӳڶ1
#define		mCH341_PARA_CMD_W0		0xA6		// 򲢿д0
#define		mCH341_PARA_CMD_W1		0xA7		// 򲢿д1
#define		mCH341_PARA_CMD_STS		0xA0		// ȡ״̬

// CH341Aڲ
#define		mCH341A_CMD_SET_OUTPUT	0xA1		// ò
#define		mCH341A_CMD_IO_ADDR		0xA2		// MEMַд/,ӴֽڿʼΪ
#define		mCH341A_CMD_PRINT_OUT	0xA3		// PRINTݴӡʽ,ӴֽڿʼΪ
#define		mCH341A_CMD_SPI_STREAM	0xA8		// SPIӿڵ,ӴֽڿʼΪ
#define		mCH341A_CMD_SIO_STREAM	0xA9		// SIOӿڵ,ӴֽڿʼΪ
#define		mCH341A_CMD_I2C_STREAM	0xAA		// I2Cӿڵ,ӴֽڿʼΪI2C
#define		mCH341A_CMD_UIO_STREAM	0xAB		// UIOӿڵ,ӴֽڿʼΪ

// CH341Aƴĳר
#define		mCH341A_BUF_CLEAR		0xB2		// δɵ
#define		mCH341A_I2C_CMD_X		0x54		// I2Cӿڵ,ִ
#define		mCH341A_DELAY_MS		0x5E		// Ϊλʱָʱ
#define		mCH341A_GET_VER			0x5F		// ȡоƬ汾

#define		mCH341_EPP_IO_MAX		( mCH341_PACKET_LENGTH - 1 )	// CH341EPP/MEMʽµζдݿ󳤶
#define		mCH341A_EPP_IO_MAX		0xFF		// CH341AEPP/MEMʽµζдݿ󳤶

#define		mCH341A_CMD_IO_ADDR_W	0x00		// MEMַд/:д,λ6-λ0Ϊַ,һֽΪд
#define		mCH341A_CMD_IO_ADDR_R	0x80		// MEMַд/:,λ6-λ0Ϊַ,һ𷵻

#define		mCH341A_CMD_I2C_STM_STA	0x74		// I2Cӿڵ:ʼλ
#define		mCH341A_CMD_I2C_STM_STO	0x75		// I2Cӿڵ:ֹͣλ
#define		mCH341A_CMD_I2C_STM_OUT	0x80		// I2Cӿڵ:,λ5-λ0Ϊ,ֽΪ,0ֻһֽڲӦ
#define		mCH341A_CMD_I2C_STM_IN	0xC0		// I2Cӿڵ:,λ5-λ0Ϊ,0ֻһֽڲӦ
#define		mCH341A_CMD_I2C_STM_MAX	( min( 0x3F, mCH341_PACKET_LENGTH ) )	// I2Cӿڵݵ󳤶
#define		mCH341A_CMD_I2C_STM_SET	0x60		// I2Cӿڵ:ò,λ2=SPII/O(0=뵥,1=˫˫),λ1λ0=I2Cٶ(00=,01=׼,10=,11=)
#define		mCH341A_CMD_I2C_STM_US	0x40		// I2Cӿڵ:΢Ϊλʱ,λ3-λ0Ϊʱֵ
#define		mCH341A_CMD_I2C_STM_MS	0x50		// I2Cӿڵ:Ϊλʱ,λ3-λ0Ϊʱֵ
#define		mCH341A_CMD_I2C_STM_DLY	0x0F		// I2Cӿڵʱֵ
#define		mCH341A_CMD_I2C_STM_END	0x00		// I2Cӿڵ:ǰ

#define		mCH341A_CMD_UIO_STM_IN	0x00		// UIOӿڵ:D7-D0
#define		mCH341A_CMD_UIO_STM_DIR	0x40		// UIOӿڵ:趨I/OD5-D0,λ5-λ0Ϊ
#define		mCH341A_CMD_UIO_STM_OUT	0x80		// UIOӿڵ:D5-D0,λ5-λ0Ϊ
#define		mCH341A_CMD_UIO_STM_US	0xC0		// UIOӿڵ:΢Ϊλʱ,λ5-λ0Ϊʱֵ
#define		mCH341A_CMD_UIO_STM_END	0x20		// UIOӿڵ:ǰ


// CH341ڹģʽ
#define		mCH341_PARA_MODE_EPP	0x00		// CH341ڹģʽΪEPPʽ
#define		mCH341_PARA_MODE_EPP17	0x00		// CH341AڹģʽΪEPPʽV1.7
#define		mCH341_PARA_MODE_EPP19	0x01		// CH341AڹģʽΪEPPʽV1.9
#define		mCH341_PARA_MODE_MEM	0x02		// CH341ڹģʽΪMEMʽ


// I/Oλ,ֱ״̬źŵλ,ֱλݶ
#define		mStateBitERR			0x00000100	// ֻд,ERR#״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitPEMP			0x00000200	// ֻд,PEMP״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitINT			0x00000400	// ֻд,INT#״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitSLCT			0x00000800	// ֻд,SLCT״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitWAIT			0x00002000	// ֻд,WAIT#״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitDATAS			0x00004000	// ֻдɶ,DATAS#/READ#״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitADDRS			0x00008000	// ֻдɶ,ADDRS#/ADDR/ALE״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitRESET			0x00010000	// ֻд,RESET#״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitWRITE			0x00020000	// ֻд,WRITE#״̬,1:ߵƽ,0:͵ƽ
#define		mStateBitSDA			0x00800000	// ֻ,SDA״̬,1:ߵƽ,0:͵ƽ


#define		MAX_DEVICE_PATH_SIZE	128			// 豸Ƶַ
#define		MAX_DEVICE_ID_SIZE		64			// 豸IDַ


typedef		VOID	( CALLBACK	* mPCH341_INT_ROUTINE ) (  // жϷ
	ULONG			iStatus );  // ж״̬,ολ˵
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT


HANDLE	WINAPI	CH341OpenDevice(  // CH341豸,ؾ,Ч
	ULONG			iIndex );  // ָCH341豸,0Ӧһ豸


VOID	WINAPI	CH341CloseDevice(  // رCH341豸
	ULONG			iIndex );  // ָCH341豸


ULONG	WINAPI	CH341GetVersion( );  // DLL汾,ذ汾


ULONG	WINAPI	CH341DriverCommand(  // ֱӴ,򷵻0,򷵻ݳ
	ULONG			iIndex,  // ָCH341豸,V1.6DLLҲ豸򿪺ľ
	mPWIN32_COMMAND	ioCommand );  // ṹָ
// óڵú󷵻ݳ,Ȼṹ,Ƕ,ݷṹ,
// صݳڲʧʱΪ0,ɹʱΪṹĳ,һֽ,򷵻mWIN32_COMMAND_HEAD+1,
// ṹڵǰ,ֱṩ:ܵŻܴ,ȡݵĳ(ѡ),(ѡ)
// ṹڵú,ֱ𷵻:״̬,ݵĳ(ѡ),
//   ״̬WINDOWSĴ,ԲοNTSTATUS.H,
//   ݵĳָصݳ,ݴĻ,дһΪ0


ULONG	WINAPI	CH341GetDrvVersion( );  // 汾,ذ汾,򷵻0


BOOL	WINAPI	CH341ResetDevice(  // λUSB豸
	ULONG			iIndex );  // ָCH341豸


BOOL	WINAPI	CH341GetDeviceDescr(  // ȡ豸
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341GetConfigDescr(  // ȡ
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341SetIntRoutine(  // 趨жϷ
	ULONG			iIndex,  // ָCH341豸
	mPCH341_INT_ROUTINE	iIntRoutine );  // ָжϷ,ΪNULLȡжϷ,жʱøó


BOOL	WINAPI	CH341ReadInter(  // ȡж
	ULONG			iIndex,  // ָCH341豸
	PULONG			iStatus );  // ָһ˫ֵԪ,ڱȡж״̬,
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT


BOOL	WINAPI	CH341AbortInter(  // жݶ
	ULONG			iIndex );  // ָCH341豸


BOOL	WINAPI	CH341SetParaMode(  // òģʽ
	ULONG			iIndex,  // ָCH341豸
	ULONG			iMode );  // ָģʽ: 0ΪEPPģʽ/EPPģʽV1.7, 1ΪEPPģʽV1.9, 2ΪMEMģʽ


BOOL	WINAPI	CH341InitParallel(  // λʼ,RST#͵ƽ
	ULONG			iIndex,  // ָCH341豸
	ULONG			iMode );  // ָģʽ: 0ΪEPPģʽ/EPPģʽV1.7, 1ΪEPPģʽV1.9, 2ΪMEMģʽ, >= 0x00000100 ֵǰģʽ


BOOL	WINAPI	CH341ReadData0(  // 0#˿ڶȡݿ
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱȡ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341ReadData1(  // 1#˿ڶȡݿ
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱȡ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341AbortRead(  // ݿ
	ULONG			iIndex );  // ָCH341豸


BOOL	WINAPI	CH341WriteData0(  // 0#˿дݿ
	ULONG			iIndex,  // ָCH341豸
	PVOID			iBuffer,  // ָһ,׼д
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


BOOL	WINAPI	CH341WriteData1(  // 1#˿дݿ
	ULONG			iIndex,  // ָCH341豸
	PVOID			iBuffer,  // ָһ,׼д
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


BOOL	WINAPI	CH341AbortWrite(  // ݿд
	ULONG			iIndex );  // ָCH341豸


BOOL	WINAPI	CH341GetStatus(  // ͨCH341ֱݺ״̬
	ULONG			iIndex,  // ָCH341豸
	PULONG			iStatus );  // ָһ˫ֵԪ,ڱ״̬,ολ˵
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT, λ23ӦCH341SDA
// λ13ӦCH341BUSY/WAIT#, λ14ӦCH341AUTOFD#/DATAS#,λ15ӦCH341SLCTIN#/ADDRS#


BOOL	WINAPI	CH341ReadI2C(  // I2Cӿڶȡһֽ
	ULONG			iIndex,  // ָCH341豸
	UCHAR			iDevice,  // 7λָI2C豸ַ
	UCHAR			iAddr,  // ָݵԪĵַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH341WriteI2C(  // I2Cӿдһֽ
	ULONG			iIndex,  // ָCH341豸
	UCHAR			iDevice,  // 7λָI2C豸ַ
	UCHAR			iAddr,  // ָݵԪĵַ
	UCHAR			iByte );  // дֽ


BOOL	WINAPI	CH341EppReadData(  // EPPʽ: WR#=1, DS#=0, AS#=1, D0-D7=input
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱȡ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341EppReadAddr(  // EPPʽַ: WR#=1, DS#=1, AS#=0, D0-D7=input
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱȡĵַ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341EppWriteData(  // EPPʽд: WR#=0, DS#=0, AS#=1, D0-D7=output
	ULONG			iIndex,  // ָCH341豸
	PVOID			iBuffer,  // ָһ,׼д
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


BOOL	WINAPI	CH341EppWriteAddr(  // EPPʽдַ: WR#=0, DS#=1, AS#=0, D0-D7=output
	ULONG			iIndex,  // ָCH341豸
	PVOID			iBuffer,  // ָһ,׼дĵַ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


BOOL	WINAPI	CH341EppSetAddr(  // EPPʽõַ: WR#=0, DS#=1, AS#=0, D0-D7=output
	ULONG			iIndex,  // ָCH341豸
	UCHAR			iAddr );  // ָEPPַ


BOOL	WINAPI	CH341MemReadAddr0(  // MEMʽַ0: WR#=1, DS#/RD#=0, AS#/ADDR=0, D0-D7=input
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱӵַ0ȡ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341MemReadAddr1(  // MEMʽַ1: WR#=1, DS#/RD#=0, AS#/ADDR=1, D0-D7=input
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱӵַ1ȡ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341MemWriteAddr0(  // MEMʽдַ0: WR#=0, DS#/RD#=1, AS#/ADDR=0, D0-D7=output
	ULONG			iIndex,  // ָCH341豸
	PVOID			iBuffer,  // ָһ,׼ַ0д
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


BOOL	WINAPI	CH341MemWriteAddr1(  // MEMʽдַ1: WR#=0, DS#/RD#=1, AS#/ADDR=1, D0-D7=output
	ULONG			iIndex,  // ָCH341豸
	PVOID			iBuffer,  // ָһ,׼ַ1д
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


BOOL	WINAPI	CH341SetExclusive(  // öռʹõǰCH341豸
	ULONG			iIndex,  // ָCH341豸
	ULONG			iExclusive );  // Ϊ0豸Թʹ,0ռʹ


BOOL	WINAPI	CH341SetTimeout(  // USBݶдĳʱ
	ULONG			iIndex,  // ָCH341豸
	ULONG			iWriteTimeout,  // ָUSBдݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
	ULONG			iReadTimeout );  // ָUSBȡݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)


BOOL	WINAPI	CH341ReadData(  // ȡݿ
	ULONG			iIndex,  // ָCH341豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱȡ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH341WriteData(  // дݿ
	ULONG			iIndex,  // ָCH341豸
	PVOID			iBuffer,  // ָһ,׼д
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


PVOID	WINAPI	CH341GetDeviceName(  // ָCH341豸ƵĻ,򷵻NULL
	ULONG			iIndex );  // ָCH341豸,0Ӧһ豸


ULONG	WINAPI	CH341GetVerIC(  // ȡCH341оƬİ汾,:0=豸Ч,0x10=CH341,0x20=CH341A
	ULONG			iIndex );  // ָCH341豸


BOOL	WINAPI	CH341FlushBuffer(  // CH341Ļ
	ULONG			iIndex );  // ָCH341豸


BOOL	WINAPI	CH341WriteRead(  // ִ,
	ULONG			iIndex,  // ָCH341豸
	ULONG			iWriteLength,  // д,׼дĳ
	PVOID			iWriteBuffer,  // ָһ,׼д
	ULONG			iReadStep,  // ׼ȡĵĳ, ׼ȡܳΪ(iReadStep*iReadTimes)
	ULONG			iReadTimes,  // ׼ȡĴ
	PULONG			oReadLength,  // ָ򳤶ȵԪ,غΪʵʶȡĳ
	PVOID			oReadBuffer );  // ָһ㹻Ļ,ڱȡ


BOOL	WINAPI	CH341SetStream(  // ôģʽ
	ULONG			iIndex,  // ָCH341豸
	ULONG			iMode );  // ָģʽ,
// λ1-λ0: I2Cӿٶ/SCLƵ, 00=/20KHz,01=׼/100KHz(Ĭֵ),10=/400KHz,11=/750KHz
// λ2:     SPII/O/IO, 0=뵥(D3ʱ/D5/D7)(Ĭֵ),1=˫˫(D3ʱ/D5D4/D7D6)
// λ7:     SPIֽеλ˳, 0=λǰ, 1=λǰ
// ,Ϊ0


BOOL	WINAPI	CH341SetDelaymS(  // Ӳ첽ʱ,úܿ췵,һ֮ǰʱָ
	ULONG			iIndex,  // ָCH341豸
	ULONG			iDelay );  // ָʱĺ


BOOL	WINAPI	CH341StreamI2C(  // I2C,2߽ӿ,ʱΪSCL,ΪSDA(׼˫I/O),ٶԼ56Kֽ
	ULONG			iIndex,  // ָCH341豸
	ULONG			iWriteLength,  // ׼дֽ
	PVOID			iWriteBuffer,  // ָһ,׼д,ֽͨI2C豸ַдλ
	ULONG			iReadLength,  // ׼ȡֽ
	PVOID			oReadBuffer );  // ָһ,غǶ


typedef	enum	_EEPROM_TYPE {					// EEPROMͺ
	ID_24C01,
	ID_24C02,
	ID_24C04,
	ID_24C08,
	ID_24C16,
	ID_24C32,
	ID_24C64,
	ID_24C128,
	ID_24C256,
	ID_24C512,
	ID_24C1024,
	ID_24C2048,
	ID_24C4096
} EEPROM_TYPE;


BOOL	WINAPI	CH341ReadEEPROM(  // EEPROMжȡݿ,ٶԼ56Kֽ
	ULONG			iIndex,  // ָCH341豸
	EEPROM_TYPE		iEepromID,  // ָEEPROMͺ
	ULONG			iAddr,  // ָݵԪĵַ
	ULONG			iLength,  // ׼ȡֽ
	PUCHAR			oBuffer );  // ָһ,غǶ


BOOL	WINAPI	CH341WriteEEPROM(  // EEPROMдݿ
	ULONG			iIndex,  // ָCH341豸
	EEPROM_TYPE		iEepromID,  // ָEEPROMͺ
	ULONG			iAddr,  // ָݵԪĵַ
	ULONG			iLength,  // ׼дֽ
	PUCHAR			iBuffer );  // ָһ,׼д


BOOL	WINAPI	CH341GetInput(  // ͨCH341ֱݺ״̬,ЧʱCH341GetStatus
	ULONG			iIndex,  // ָCH341豸
	PULONG			iStatus );  // ָһ˫ֵԪ,ڱ״̬,ολ˵
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT, λ23ӦCH341SDA
// λ13ӦCH341BUSY/WAIT#, λ14ӦCH341AUTOFD#/DATAS#,λ15ӦCH341SLCTIN#/ADDRS#


BOOL	WINAPI	CH341SetOutput(  // CH341I/O,ͨCH341ֱ
/* ***** ʹøAPI, ֹ޸I/OʹűΪŵ֮·оƬ ***** */
	ULONG			iIndex,  // ָCH341豸
	ULONG			iEnable,  // Ч־,ολ˵
// λ0Ϊ1˵iSetDataOutλ15-λ8Ч,
// λ1Ϊ1˵iSetDirOutλ15-λ8Ч,
// λ2Ϊ1˵iSetDataOut7-λ0Ч,
// λ3Ϊ1˵iSetDirOutλ7-λ0Ч,
// λ4Ϊ1˵iSetDataOutλ23-λ16Ч,
	ULONG			iSetDirOut,  // I/O,ĳλ0ӦΪ,ĳλ1ӦΪ,ڷʽĬֵΪ0x000FC000,ολ˵
	ULONG			iSetDataOut );  // ,I/OΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ,ολ˵
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT
// λ13ӦCH341WAIT#, λ14ӦCH341DATAS#/READ#,λ15ӦCH341ADDRS#/ADDR/ALE
// ֻ,I/O: λ16ӦCH341RESET#, λ17ӦCH341WRITE#, λ18ӦCH341SCL, λ29ӦCH341SDA


BOOL	WINAPI	CH341Set_D5_D0(  // CH341D5-D0ŵI/O,ͨCH341D5-D0ֱ,ЧʱCH341SetOutput
/* ***** ʹøAPI, ֹ޸I/OʹűΪŵ֮·оƬ ***** */
	ULONG			iIndex,  // ָCH341豸
	ULONG			iSetDirOut,  // D5-D0ŵI/O,ĳλ0ӦΪ,ĳλ1ӦΪ,ڷʽĬֵΪ0x00ȫ
	ULONG			iSetDataOut );  // D5-D0ŵ,I/OΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ
// ݵλ5-λ0ֱӦCH341D5-D0


BOOL	WINAPI	CH341StreamSPI3(  // SPI,3߽ӿ,ʱΪDCK2/SCL,ΪDIO/SDA(׼˫I/O),ƬѡΪD0/D1/D2,ٶԼ51Kֽ
/* SPIʱ: DCK2/SCLΪʱ, ĬΪ͵ƽ, DIO/SDAʱ֮ǰ, DIO/SDAʱ½֮ */
	ULONG			iIndex,  // ָCH341豸
	ULONG			iChipSelect,  // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
	ULONG			iLength,  // ׼ֽ
	PVOID			ioBuffer );  // ָһ,׼DIOд,غǴDIO


BOOL	WINAPI	CH341StreamSPI4(  // SPI,4߽ӿ,ʱΪDCK/D3,ΪDOUT/D5,ΪDIN/D7,ƬѡΪD0/D1/D2,ٶԼ68Kֽ
/* SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5ʱ֮ǰ, DIN/D7ʱ½֮ */
	ULONG			iIndex,  // ָCH341豸
	ULONG			iChipSelect,  // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
	ULONG			iLength,  // ׼ֽ
	PVOID			ioBuffer );  // ָһ,׼DOUTд,غǴDIN


BOOL	WINAPI	CH341StreamSPI5(  // SPI,5߽ӿ,ʱΪDCK/D3,ΪDOUT/D5DOUT2/D4,ΪDIN/D7DIN2/D6,ƬѡΪD0/D1/D2,ٶԼ30Kֽ*2
/* SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5DOUT2/D4ʱ֮ǰ, DIN/D7DIN2/D6ʱ½֮ */
	ULONG			iIndex,  // ָCH341豸
	ULONG			iChipSelect,  // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
	ULONG			iLength,  // ׼ֽ
	PVOID			ioBuffer,  // ָһ,׼DOUTд,غǴDIN
	PVOID			ioBuffer2 );  // ָڶ,׼DOUT2д,غǴDIN2


BOOL	WINAPI	CH341BitStreamSPI(  // SPIλ,4/5߽ӿ,ʱΪDCK/D3,ΪDOUT/DOUT2,ΪDIN/DIN2,ƬѡΪD0/D1/D2,ٶԼ8Kλ*2
	ULONG			iIndex,  // ָCH341豸
	ULONG			iLength,  // ׼λ,һ896,鲻256
	PVOID			ioBuffer );  // ָһ,׼DOUT/DOUT2/D2-D0д,غǴDIN/DIN2
/* SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5DOUT2/D4ʱ֮ǰ, DIN/D7DIN2/D6ʱ½֮ */
/* ioBufferеһֽڹ8λֱӦD7-D0, λ5DOUT, λ4DOUT2, λ2-λ0D2-D0, λ7DIN, λ6DIN2, λ3ݺ */
/* ڵøAPI֮ǰ,ӦȵCH341Set_D5_D0CH341D5-D0ŵI/O,ŵĬϵƽ */


BOOL	WINAPI	CH341SetBufUpload(  // 趨ڲϴģʽ
	ULONG			iIndex,  // ָCH341豸,0Ӧһ豸
	ULONG			iEnableOrClear );  // Ϊ0ֹڲϴģʽ,ʹֱϴ,0ڲϴģʽе
// ڲϴģʽ,ôCH341򴴽߳ԶUSBϴݵڲ,ͬʱе,ӦóCH341ReadDataػе


LONG	WINAPI	CH341QueryBufUpload(  // ѯڲϴеݰ,ɹݰ,-1
	ULONG			iIndex );  // ָCH341豸,0Ӧһ豸


BOOL	WINAPI	CH341SetBufDownload(  // 趨ڲ´ģʽ
	ULONG			iIndex,  // ָCH341豸,0Ӧһ豸
	ULONG			iEnableOrClear );  // Ϊ0ֹڲ´ģʽ,ʹֱ´,0ڲ´ģʽе
// ڲ´ģʽ,ôӦóCH341WriteData󽫽ǽUSB´ݷŵڲ,CH341򴴽߳Զֱ


LONG	WINAPI	CH341QueryBufDownload(  // ѯڲ´еʣݰ(δ),ɹݰ,-1
	ULONG			iIndex );  // ָCH341豸,0Ӧһ豸


BOOL	WINAPI	CH341ResetInter(  // λжݶ
	ULONG			iIndex );  // ָCH341豸


BOOL	WINAPI	CH341ResetRead(  // λݿ
	ULONG			iIndex );  // ָCH341豸


BOOL	WINAPI	CH341ResetWrite(  // λݿд
	ULONG			iIndex );  // ָCH341豸


typedef		VOID	( CALLBACK	* mPCH341_NOTIFY_ROUTINE ) (  // 豸¼֪ͨص
	ULONG			iEventStatus );  // 豸¼͵ǰ״̬(ж): 0=豸γ¼, 3=豸¼

#define		CH341_DEVICE_ARRIVAL		3		// 豸¼,Ѿ
#define		CH341_DEVICE_REMOVE_PEND	1		// 豸Ҫγ
#define		CH341_DEVICE_REMOVE			0		// 豸γ¼,Ѿγ


BOOL	WINAPI	CH341SetDeviceNotify(  // 趨豸¼֪ͨ
	ULONG					iIndex,  // ָCH341豸,0Ӧһ豸
	PCHAR					iDeviceID,  // ѡ,ַָ,ָص豸ID,ַ\0ֹ
	mPCH341_NOTIFY_ROUTINE	iNotifyRoutine );  // ָ豸¼ص,ΪNULLȡ¼֪ͨ,ڼ⵽¼ʱøó


BOOL	WINAPI	CH341SetupSerial(  // 趨CH341Ĵ,APIֻڹڴڷʽCH341оƬ
	ULONG					iIndex,  // ָCH341豸,0Ӧһ豸
	ULONG					iParityMode,  // ָCH341ڵУģʽ: NOPARITY/ODDPARITY/EVENPARITY/MARKPARITY/SPACEPARITY
	ULONG					iBaudRate );  // ָCH341ڵͨѶֵ,503000000ֵ֮


/*  APIڹڴڷʽCH341оƬ,֮APIһֻڲڷʽCH341оƬ
	CH341OpenDevice
	CH341CloseDevice
	CH341SetupSerial
	CH341ReadData
	CH341WriteData
	CH341SetBufUpload
	CH341QueryBufUpload
	CH341SetBufDownload
	CH341QueryBufDownload
	CH341SetDeviceNotify
	CH341GetStatus
//  ҪAPI,ǴҪAPI
	CH341GetVersion
	CH341DriverCommand
	CH341GetDrvVersion
	CH341ResetDevice
	CH341GetDeviceDescr
	CH341GetConfigDescr
	CH341SetIntRoutine
	CH341ReadInter
	CH341AbortInter
	CH341AbortRead
	CH341AbortWrite
	CH341ReadI2C
	CH341WriteI2C
	CH341SetExclusive
	CH341SetTimeout
	CH341GetDeviceName
	CH341GetVerIC
	CH341FlushBuffer
	CH341WriteRead
	CH341ResetInter
	CH341ResetRead
	CH341ResetWrite
*/


#ifdef __cplusplus
}
#endif

#endif		// _CH341_DLL_H
