// 汾: V1.3
// ʱ: 2008-5-23  2009-1-12
// :
// 뻷: VC6.0
// : rgw@wch.cn
//#define     UNICODE
//#ifdef      UNICODE
//#define     _UNICODE
//#endif
#include    <windows.h>
#include    <tchar.h>
#include    <stdio.h>
#include    <string.h>
#include    <locale.h>
#include    <stdlib.h>
#include    <commctrl.h>                // ṩؼ
#include    "CH341DP.H"
#include    "resource.h"                // ԴUNICODE
#include    "CH341DLL.H"                // CH341Ķ̬ӿ
#include    "CH341IO.H"                 // ýӿں
#include    "MSHOW.H"                   // ڴݶȡ(ڵ)

#pragma comment(lib, "comctl32")

// ʹȫֱ
HINSTANCE   DownExeHins;                        // ʵ
HWND        MainDialog;                         // Ի
TCHAR       DownFileBuf[260];                   // ļ·
HANDLE      Downhandle;                         // ߳̾
HWND        HwndProg;                           // ؽ
PBRANGE     DownProgRange;                      // ؽķΧ

BOOL        Ch341State;                         // TUREʾ豸Ǻõ
HANDLE      Ch341Handle;                        // CH341ľ
ULONG       Ch341index;                         // CH341к
LONG        McuType;                            // MCUȫֱ
BOOL        IsEepromData;                       // TUREEEPROMĬǳ

BOOL        CmdMode;                            // ģʽ
USHORT      McuCmd;                             // 
ULONG       CH341ChipVer;                       // оƬ汾

BOOL        StopBit;                            // ֹͣ־λ
BOOL        CH341SPIBitSet;                     // ֧SPI־λ

static      BOOL        CH341SPIBit;            // Ƿ֧SPI
static      HMENU       hSysMenu;               // ϵͳ˵

static      UCHAR       pBinBuf[MAX_FILE_LEN];  // binݴŻ
static      UCHAR       pFileBuf[MAX_FILE_LEN]; // ļݴŻ
static      BOOL        FileOpenBit;            // ļ򿪱־λ

// ʾCMDַ
PTCHAR     CH341DP_HELP_STR = _T("1.ʾ\nCH341DP /? \n\n2.ļ\nCH341DP %1 \
%2 %3\n1: ο渴λĲ1\n2: WF FLASH WE EEPROM\n3: \
ļ·\n: CH341DP MEGA8  WF \"D:\\down\\down.hex\"\nʵְdown.hex\
MEGA8FLASH\n\n3.λ\nCH341DP %1 %2\n1:ȡֵ:\nMEGA , MEGA8, MEGA16,\
 MEGA32, MEGA64, MEGA128, MEGA8515,\nMEGA8535, MEGA48 MEGA88,MEGA168, AT89S51,AT89S52\
\n MEGA ΪԶʶֵ֧MEGAϵMCU\n2: RM\n: CH341DP AT89S51 RM\nʵֶ\
AT89S51ĸλ");

/*==============================================================================

: SetSpiSysMenu

: Ƿ֧SPI

==============================================================================*/
void SetSpiSysMenu( void )
{
ULONG i;

    // Ĭϲ֧SPI4
    i = MF_UNCHECKED;
    CheckMenuItem( hSysMenu, IDC_SET_SPI, i );

    if( CH341SPIBit )
        i = MFS_ENABLED;
    else
        i = MFS_GRAYED;
    EnableMenuItem( hSysMenu, IDC_SET_SPI, i );
}

/*==============================================================================

: CheckSysMenu

:

==============================================================================*/
void CheckSysMenu( void )
{
ULONG i;

    if( CH341SPIBitSet )
        i = MF_CHECKED;
    else
        i = MF_UNCHECKED;
    CheckMenuItem( hSysMenu, IDC_SET_SPI, i );
}

/*==============================================================================

: SetSpiRegConfig

: дSPIú

==============================================================================*/
void SetSpiRegConfig( void )
{
HKEY    hKey;

    RegCreateKey( HKEY_CURRENT_USER, CH341DP_SETTINGS_KEY,	&hKey );
    RegSetValueEx( hKey, TEXT("SPIBit"), 0, REG_DWORD, (CONST BYTE *)&CH341SPIBitSet,
        sizeof(CH341SPIBitSet) );
    RegCloseKey( hKey );
}

/*==============================================================================

: ReadSpiRegConfig

: SPIú

==============================================================================*/
void ReadSpiRegConfig( void )
{
HKEY    hKey;
ULONG   ParamSize, type, i;

    RegCreateKey( HKEY_CURRENT_USER, CH341DP_SETTINGS_KEY,	&hKey );

    ParamSize = sizeof( CH341SPIBitSet );
    type = REG_DWORD;
    i = RegQueryValueEx( hKey, TEXT("SPIBit"), NULL, &type,
        (LPBYTE)&CH341SPIBitSet, &ParamSize );
    if( i==0x02 )
    {   //ûд,ѡ1
        CH341SPIBitSet = 1;
    }
    CheckSysMenu( );
    RegCloseKey( hKey );
}

/*==============================================================================

: SetMcuIndexReg

: д

==============================================================================*/
void SetMcuIndexReg( ULONG index )
{
HKEY    hKey;

    RegCreateKey( HKEY_CURRENT_USER, CH341DP_SETTINGS_KEY,	&hKey );
    RegSetValueEx( hKey, TEXT("IniMcuIndex"), 0, REG_DWORD, (CONST BYTE *)&index,
        sizeof( index ) );
    RegCloseKey( hKey );
}

/*==============================================================================

: ReadMcuIndexReg

: 

==============================================================================*/
ULONG ReadMcuIndexReg( void )
{
HKEY    hKey;
ULONG   ParamSize, type, i, IniMcuIndex;

    RegCreateKey( HKEY_CURRENT_USER, CH341DP_SETTINGS_KEY,	&hKey );

    ParamSize = sizeof( IniMcuIndex );
    type = REG_DWORD;
    i = RegQueryValueEx( hKey, TEXT("IniMcuIndex"), NULL, &type,
        (LPBYTE)&IniMcuIndex, &ParamSize );
    if( i==0x02 )
    {   //ûд,Ϊ0
        IniMcuIndex = 0;
    }
    RegCloseKey( hKey );
    return IniMcuIndex;
}

/*==============================================================================

: ReadWindowPosReg

: λ

==============================================================================*/
void ReadWindowPosReg( void )
{
HKEY    hKey;
ULONG   ParamSize, type, i;
LONG   x, y;

    RegCreateKey( HKEY_CURRENT_USER, CH341DP_SETTINGS_KEY,	&hKey );

    ParamSize = sizeof( x );
    type = REG_DWORD;
    i = RegQueryValueEx( hKey, TEXT("x_pos"), NULL, &type,
        (LPBYTE)&x, &ParamSize );
    if( i==0x02 )
        return;

    ParamSize = sizeof( y );
    type = REG_DWORD;
    i = RegQueryValueEx( hKey, TEXT("y_pos"), NULL, &type,
        (LPBYTE)&y, &ParamSize );
    if( i==0x02 )
        return;

    // жǷĻΧ
    if( ( (x< 0) || (x > GetSystemMetrics( SM_CXFULLSCREEN ) ))  
        || ( (y< 0) || (y > GetSystemMetrics( SM_CYFULLSCREEN )) ) )
        return;
    MoveWindow( MainDialog, x, y, 474, 244, TRUE );
}

/*==============================================================================

: WriteWindowPosReg

: дλ

==============================================================================*/
void WriteWindowPosReg( void )
{
HKEY    hKey;
RECT    rt;
 
    // Сʱ洰λ
    if( IsIconic( MainDialog ) )
        return;
    GetWindowRect( MainDialog, &rt );
    RegCreateKey( HKEY_CURRENT_USER, CH341DP_SETTINGS_KEY,	&hKey );
    RegSetValueEx( hKey, TEXT("x_pos"), 0, REG_DWORD, (CONST BYTE *)&rt.left,
        sizeof( rt.left ) );
    RegSetValueEx( hKey, TEXT("y_pos"), 0, REG_DWORD, (CONST BYTE *)&rt.top,
        sizeof( rt.top ) );
    RegCloseKey( hKey );
}

/*==============================================================================

: SetWindowCenter

: Ӵλڵмλ

==============================================================================*/
static  void SetWindowCenter( HWND hSonWindow )
{
RECT DesktopRect, NewRect, OldMainRect;
POINT pCenter, pStart;
LONG width, height;

    // ǷС
    if( IsIconic( MainDialog ) )
        ShowWindow( MainDialog, SW_SHOWNORMAL );

    GetWindowRect( MainDialog, &OldMainRect );
    GetWindowRect( GetDesktopWindow(), &DesktopRect );
    GetWindowRect( hSonWindow, &NewRect );          // õӴڵĳ

    width = NewRect.right - NewRect.left;
    height = NewRect.bottom - NewRect.top;

    // calculate message box starting point
    pCenter.x = OldMainRect.left+((OldMainRect.right - OldMainRect.left)/2);
    pCenter.y = OldMainRect.top+((OldMainRect.bottom - OldMainRect.top)/2);

    // adjust if message box is off desktop
    pStart.x = (pCenter.x - (width/2) );
    pStart.y = (pCenter.y - (height/2) );

    if(pStart.x < 0)
        pStart.x = 0;
    if(pStart.y < 0)
        pStart.y = 0;

    if(pStart.x + width > DesktopRect.right)
        pStart.x = DesktopRect.right - width;
    if(pStart.y + height > DesktopRect.bottom)
        pStart.y = DesktopRect.bottom - height;

    MoveWindow( hSonWindow, pStart.x, pStart.y, width, height, TRUE );
}

static HHOOK   hHook;
/*==============================================================================

:  CBTProc

: hook MessageBoxCenter ʹ䴦Ӧóмλ

==============================================================================*/
LRESULT
CALLBACK
CBTProc( int nCode, WPARAM wParam, LPARAM lParam )
{
    if(nCode == HCBT_ACTIVATE)
    {
        SetWindowCenter( (HWND)wParam );
        UnhookWindowsHookEx( hHook );
    }
    return CallNextHookEx( hHook, nCode, wParam, lParam );
}

/*==============================================================================

:  SetWindowHook

: ùҹ

==============================================================================*/
VOID SetWindowHook( VOID )
{
   hHook = SetWindowsHookEx( WH_CBT, CBTProc, GetModuleHandle(NULL),
       GetCurrentThreadId() );
}

/*==============================================================================

: MessageBoxCenter

: öԻλڵмλ

==============================================================================*/
int MessageBoxCenter(HWND hWnd, LPCTSTR lpText, LPCTSTR lpCaption,UINT uType )
{
    SetWindowHook( );
    return MessageBox( hWnd, lpText, lpCaption,uType );
}

/*==============================================================================

: IniCh341Device

: ʼCH341豸

==============================================================================*/
void IniCh341Device( void )
{
    Ch341Handle = CH341OpenDevice( Ch341index );
    if ( Ch341Handle  == INVALID_HANDLE_VALUE )
    {
        EnableWindow( GetDlgItem( MainDialog, IDC_BUTTON_DOWN ), 0 );
        EnableWindow( GetDlgItem( MainDialog, IDC_SET_CONFIG), 0);
        EnableWindow( GetDlgItem( MainDialog, IDC_RUNING ), 0 );
        EnableWindow( GetDlgItem( MainDialog, IDC_BUTTON_BROWER ), 0 );
        SetDlgItemText( MainDialog, IDC_STATIC_PROMPT, _T("CH341豸ʧȥ") );
        Ch341State = FALSE;
    }
    else
    {
        CH341SetExclusive( Ch341index, TRUE );
        CH341ChipVer = CH341GetVerIC( Ch341index );
        CH341SPIBit = FALSE;
        if( CH341ChipVer >= 0x30 )
        {
            CH341SPIBit = TRUE;
            // ôģʽ
            CH341SetStream( Ch341index, 0x81 );
        }

        // ֧ ֹ
        SetSpiSysMenu( );
        // ֧SPI ò
        if( CH341SPIBit )
            ReadSpiRegConfig( );

        EnableWindow( GetDlgItem( MainDialog, IDC_SET_CONFIG), 1 );
        EnableWindow( GetDlgItem( MainDialog, IDC_RUNING ), 1 );
        EnableWindow( GetDlgItem( MainDialog, IDC_BUTTON_BROWER ), 1 );
        EnableWindow( GetDlgItem( MainDialog, IDC_BUTTON_DOWN ), FileOpenBit );
        SetDlgItemText( MainDialog, IDC_STATIC_PROMPT, _T("ɹCH341豸") );
        Ch341State = TRUE;
    }
}

/*==============================================================================

: CH341DP_NOTIFY_ROUTINE

: CH341豸жϻص

==============================================================================*/
void CALLBACK CH341DP_NOTIFY_ROUTINE(ULONG iDevIndexAndEvent)
{
PVOID pName;
UCHAR i;

    if( iDevIndexAndEvent == 3 )        // 豸¼,Ѿ
    {
        if( Ch341State == FALSE )       // ǰ豸豸
        {
            Ch341index = 0;             // 0豸ʼɨ豸,ҵŽС豸
            for( i=0; i!=mCH341_MAX_NUMBER; i++)
            {
                Ch341index = i;
                IniCh341Device( );
                if( Ch341State == TRUE )
                    break;
            }
        }
    }
    else if( CH341_DEVICE_REMOVE == 0 ) // 豸γ¼,Ѿγ
    {
        if( Ch341State == TRUE )
        {
            pName = CH341GetDeviceName( Ch341index );
            if( pName == NULL )         // õ豸,³ʼ豸
            {
                IniCh341Device( );
            }
        }
    }
}

/*==============================================================================

: ShowTitleName

: Titleʾļ

==============================================================================*/
void ShowTitleName( void )
{
PCHAR   p;
TCHAR   BakDownFileBuf[260+32];

    p = strrchr( DownFileBuf, '\\' );
    if( p )
        _stprintf( BakDownFileBuf, _T (APPNAME" "APPVER " - [%s]"), p+1 );
    else
        _stprintf( BakDownFileBuf, _T (APPNAME" "APPVER " - [%s]"), DownFileBuf );
    SetWindowText( MainDialog, BakDownFileBuf );
}

/*==============================================================================

: InitRunGui

: ʼʱ

==============================================================================*/
void InitRunGui( BOOL RunBit )
{
ULONG i;

    EnableWindow( GetDlgItem( MainDialog, IDC_EPRAM ), !RunBit );
    if( !RunBit )
    {   // EEPROM
        i = SendDlgItemMessage( MainDialog, IDC_MCU_MODEL, CB_GETCURSEL, 0, 0 ); 
        if(i >= ATMEL_AT89S51_MODEL)
            EnableWindow( GetDlgItem( MainDialog, IDC_EPRAM ), 0 );
    }

    EnableWindow( GetDlgItem( MainDialog, IDC_SET_CONFIG ), !RunBit );
    EnableWindow( GetDlgItem( MainDialog, IDC_BUTTON_BROWER ), !RunBit );
    EnableWindow( GetDlgItem( MainDialog, IDC_RUNING ), !RunBit );
    if( RunBit )
        SetDlgItemText( MainDialog, IDC_BUTTON_DOWN, _T( "ֹͣ") );
    else
        SetDlgItemText( MainDialog, IDC_BUTTON_DOWN, _T( "" ) );
    if( !RunBit )
    {
        if( MainDialog != GetForegroundWindow( ) )
            FlashWindow( MainDialog, TRUE );
    }
}

/*==============================================================================

: _DownThread

: س߳

==============================================================================*/
void _DownThread( HANDLE hDialog )
{
HANDLE FileHandle;              // Ŵļľ
ULONG FileLong;                 // ļ
LPVOID pFile;                   // ļڴӳָ
TCHAR CharBuf[256];             // ַ
ULONG len;
UCHAR i;

    InitRunGui( TRUE );
    SendMessage( HwndProg, PBM_SETPOS, (WPARAM)DownProgRange.iLow, (LPARAM)0 );
                            // ʼع(MCUǷɱ,Ϊɱ״̬)
    SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ʶMCUͺ...") );
    i = IniMcuDown( );
    if( i == DATA_TRANS_ERR )
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ݴʧ") );
        goto PRG_EXIT;
    }
    else if( i == NO_MCU_ERR )                  // ޷ʶMCU
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("޷ʶMCU") );
        goto PRG_EXIT;
    }
    else if( i == MCU_MODEL_ERR )               // ͺŴ
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("MCUͺ") );
        goto PRG_EXIT;
    }
    else if( i == NO_SUPORT_ERR )
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ִ֧MCU") );
    }

    FileHandle = CreateFile( DownFileBuf, GENERIC_READ, FILE_SHARE_READ, NULL,
            OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 );
    if( FileHandle == INVALID_HANDLE_VALUE )
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ļʧ") );
        goto PRG_EXIT;
    }
                                // õļ
    FileLong = GetFileSize( FileHandle, NULL );
    if( FileLong == 0  ||  FileLong > MAX_FILE_LEN )
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ļС") );
        CloseHandle( FileHandle );
        goto PRG_EXIT;
    }

    if( !ReadFile( FileHandle, pFileBuf, FileLong, &FileLong, NULL ) )
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ļ") );
        CloseHandle( FileHandle );
        goto PRG_EXIT;
    }
    CloseHandle( FileHandle );

    pFile = pFileBuf;
    len = _tcslen( DownFileBuf );    // õļ·
    if( !memicmp( &DownFileBuf[len-3], _T("HEX"), 3 ) )
    {                               // HEXļ?תΪBINļ
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ڽļת...") );
        if( HexToBin( pFile, FileLong, pBinBuf, &FileLong ) == FALSE )
        {
            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("HEXļ") );
            goto PRG_EXIT;
        }
        pFile = pBinBuf;            // ļָ滻ΪBINָ
    }

    if( IsEepromData == FALSE )
    {                               // سݵMCU
        _stprintf( CharBuf, _T("ڶ%sFLASHб..."), McuName[McuType] );
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, CharBuf );
        i = DownPrgToMcu( pFile, FileLong );
    }
    else
    {                               // ݵEEPROM
        _stprintf( CharBuf, _T("ڶ%sEEPROMб..."), McuName[McuType] );
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, CharBuf );
        i = DownDataToMcu( pFile, FileLong );
    }

    if( i == NO_ERR )
    {
        _stprintf( CharBuf, _T("سɹ,%dֽ"), FileLong );
        //MessageBoxCenter( hDialog, CharBuf,_T(APPNAME), MB_OK | MB_ICONINFORMATION);
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, CharBuf );
        goto PRG_EXIT;           // ڵϢļйر
    }
    else if( i == DATA_TRANS_ERR )
    {
        //SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ݴʧ,ˢ豸" );
    }
    else if( i == DATA_CMP_ERR )
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("У,") );
    }
    else if( i == DATA_LEN_ERR )
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ļЧȳоƬ") );
    }
    else if( i == REQ_STOP_ERR )
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ûֹ") );
    }
    else
    {
        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("δ֪") );
    }

    PRG_EXIT:
    SendMessage( HwndProg, PBM_SETPOS, (WPARAM)DownProgRange.iLow, (LPARAM)0 );
    InitRunGui( FALSE );
    Downhandle = INVALID_HANDLE_VALUE;
    return;
}

/*==============================================================================

: SetMcuConfig

:  öԻص

==============================================================================*/
LRESULT CALLBACK MegaSetMcuConfig( HWND hDialog, UINT uMessage, WPARAM wParam, LPARAM lParam )
{
INT wmId, wmEvent;
UCHAR CmdBuf[256];
TCHAR CharBUf[256];

    switch( uMessage )
    {
        case WM_INITDIALOG:
        {
            // ı
            if( ( McuType == ATMEL_MEGA16_MODEL ) || ( McuType == ATMEL_MEGA32_MODEL )
                || ( McuType == ATMEL_MEGA64_MODEL ) || ( McuType == ATMEL_MEGA128_MODEL ) )
            {
                SetDlgItemText( hDialog, IDC_CHECK_RSTD, _T("OCDEN") );
                SetDlgItemText( hDialog, IDC_CHECK_WDTON, _T("JTAGEN") );
            }
            else if( McuType == ATMEL_MEGA8515_MODEL )
            {
                SetDlgItemText( hDialog, IDC_CHECK_RSTD, _T("S8515C") );
            }
            else if( McuType == ATMEL_MEGA8535_MODEL )
            {
                SetDlgItemText( hDialog, IDC_CHECK_RSTD, _T("S8535C") );
            }
            else if( ( McuType == ATMEL_MEGA48_MODEL )
                || ( McuType == ATMEL_MEGA88_MODEL ) || ( McuType == ATMEL_MEGA168_MODEL ) )
            {
                SetDlgItemText( hDialog, IDC_CHECK_WDTON, _T("DWEN") );
                SetDlgItemText( hDialog, IDC_CHECK_CKOPT, _T("WDTON") );
                SetDlgItemText( hDialog, IDC_CHECK_BOOTSZ1, _T("BLEVEL2") );
                SetDlgItemText( hDialog, IDC_CHECK_BOOTSZ0, _T("BLEVEL1") );
                SetDlgItemText( hDialog, IDC_CHECK_BOOTRST, _T("BLEVEL0") );

                SetDlgItemText( hDialog, IDC_CHECK_BODLEVEL, _T("CKDIV8") );
                SetDlgItemText( hDialog, IDC_CHECK_BODEN, _T("CKOUT") );
            }

            SetDlgItemText( hDialog, IDC_CHECK_WDTON1, _T("0") );
            SetDlgItemText( hDialog, IDC_CHECK_M103C, _T("1") );
            SetDlgItemText( hDialog, IDC_EXPAND_SET2, _T("2") );
            if( McuType == ATMEL_MEGA48_MODEL )
            {
                SetDlgItemText( hDialog, IDC_CHECK_WDTON1, _T("SPMEN") );
                EnableWindow( GetDlgItem( hDialog, IDC_CHECK_M103C ), 0 );
                EnableWindow( GetDlgItem( hDialog, IDC_EXPAND_SET2 ), 0 );
            }
            else if( ( McuType == ATMEL_MEGA128_MODEL ) || ( McuType == ATMEL_MEGA64_MODEL ) )
            {
                SetDlgItemText( hDialog, IDC_CHECK_WDTON1, _T("WDTON") );
                SetDlgItemText( hDialog, IDC_CHECK_M103C, _T("M103C") );
                EnableWindow( GetDlgItem( hDialog, IDC_EXPAND_SET2 ), 0 );
            }
            else if( ( McuType == ATMEL_MEGA88_MODEL ) || ( McuType == ATMEL_MEGA168_MODEL ) )
            {
                SetDlgItemText( hDialog, IDC_CHECK_WDTON1, _T("BTRST") );
                SetDlgItemText( hDialog, IDC_CHECK_M103C, _T("BTSZ0") );
                SetDlgItemText( hDialog, IDC_EXPAND_SET2, _T("BTSZ1") );
            }
            else
            {
                EnableWindow( GetDlgItem( hDialog, IDC_CHECK_M103C ), 0 );
                EnableWindow( GetDlgItem( hDialog, IDC_CHECK_WDTON1 ), 0 );
                EnableWindow( GetDlgItem( hDialog, IDC_EXPAND_SET2 ), 0 );
            }
            // ĬϿʼ
            SendMessage( hDialog, WM_COMMAND, MAKELONG(IDC_READ_CONG, 0xffff), 0 );
            SetWindowCenter( hDialog );
        }
        return TRUE;

        case WM_COMMAND:
        {
            wmId = LOWORD(wParam);
            wmEvent = HIWORD(wParam);
            switch( wmId )
            {
                case IDC_SET_ALL:
                {
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk12, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk11, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk02, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk01, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk01, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_LOCK2, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_LOCK1, BST_CHECKED );

                    CheckDlgButton( hDialog, IDC_CHECK_RSTD, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_WDTON, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_SPIEN, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKOPT, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_EESAVE, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTSZ1, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTSZ0, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTRST, BST_CHECKED );

                    CheckDlgButton( hDialog, IDC_CHECK_BODLEVEL, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BODEN, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_SUT1, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_SUT0, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL3, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL2, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL1, BST_CHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL0, BST_CHECKED );

                    if( McuType == ATMEL_MEGA128_MODEL )
                    {
                        CheckDlgButton( hDialog, IDC_CHECK_M103C, BST_CHECKED );
                        CheckDlgButton( hDialog, IDC_CHECK_WDTON1, BST_CHECKED );
                    }
                    else if( McuType == ATMEL_MEGA48_MODEL )
                    {
                        CheckDlgButton( hDialog, IDC_CHECK_WDTON1, BST_CHECKED );
                    }
                    else if( ( McuType == ATMEL_MEGA88_MODEL ) || McuType == ATMEL_MEGA168_MODEL )
                    {
                        CheckDlgButton( hDialog, IDC_EXPAND_SET2, BST_CHECKED );
                        CheckDlgButton( hDialog, IDC_CHECK_M103C, BST_CHECKED );
                        CheckDlgButton( hDialog, IDC_CHECK_WDTON1, BST_CHECKED );
                    }

                }
                return TRUE;

                case IDC_CLR_ALL:
                {
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk12, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk11, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk02, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk01, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk01, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_LOCK2, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_LOCK1, BST_UNCHECKED );

                    CheckDlgButton( hDialog, IDC_CHECK_RSTD, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_WDTON, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_SPIEN, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKOPT, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_EESAVE, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTSZ1, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTSZ0, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTRST, BST_UNCHECKED );

                    CheckDlgButton( hDialog, IDC_CHECK_BODLEVEL, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_BODEN, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_SUT1, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_SUT0, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL3, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL2, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL1, BST_UNCHECKED );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL0, BST_UNCHECKED );

                    if( McuType == ATMEL_MEGA128_MODEL )
                    {
                        CheckDlgButton( hDialog, IDC_CHECK_M103C, BST_UNCHECKED );
                        CheckDlgButton( hDialog, IDC_CHECK_WDTON1, BST_UNCHECKED );
                    }
                    else if( McuType == ATMEL_MEGA48_MODEL )
                    {
                        CheckDlgButton( hDialog, IDC_CHECK_WDTON1, BST_UNCHECKED );
                    }
                    else if( ( McuType == ATMEL_MEGA88_MODEL ) || McuType == ATMEL_MEGA168_MODEL )
                    {
                        CheckDlgButton( hDialog, IDC_EXPAND_SET2, BST_UNCHECKED );
                        CheckDlgButton( hDialog, IDC_CHECK_M103C, BST_UNCHECKED );
                        CheckDlgButton( hDialog, IDC_CHECK_WDTON1, BST_UNCHECKED );
                    }
                }
                return TRUE;

                case IDC_READ_CONG:
                {
                    CmdBuf[0] = 0x58;                           // λ
                    CmdBuf[1] = 0x00;
                    CmdBuf[2] = 0x00;
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
                    {
                        MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                            MB_OK | MB_ICONEXCLAMATION );
                        return TRUE;
                    }
                    //MHEX( CmdBuf, 4, "1" );

                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk12, !GET_DWORD_BIT( CmdBuf[3], 5) );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk11, !GET_DWORD_BIT( CmdBuf[3], 4) );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk02, !GET_DWORD_BIT( CmdBuf[3], 3) );
                    CheckDlgButton( hDialog, IDC_CHECK_BLOCk01, !GET_DWORD_BIT( CmdBuf[3], 2) );
                    CheckDlgButton( hDialog, IDC_CHECK_LOCK2, !GET_DWORD_BIT( CmdBuf[3], 1) );
                    CheckDlgButton( hDialog, IDC_CHECK_LOCK1, !GET_DWORD_BIT( CmdBuf[3], 0) );

                    if( McuType == ATMEL_MEGA128_MODEL || ( McuType == ATMEL_MEGA48_MODEL )
                        || ( McuType == ATMEL_MEGA88_MODEL ) || ( McuType == ATMEL_MEGA128_MODEL ))
                    {
                        CmdBuf[0] = 0x50;                       // չ˿λ
                        CmdBuf[1] = 0x08;
                        CmdBuf[2] = 0x00;
                        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
                        {
                            MessageBoxCenter( hDialog, _T("ݴʧ"),
                                _T(APPNAME), MB_OK | MB_ICONEXCLAMATION );
                            return TRUE;
                        }
                        //MHEX( CmdBuf, 4, "3" );
                        CheckDlgButton( hDialog, IDC_EXPAND_SET2, !GET_DWORD_BIT( CmdBuf[3], 2) );
                        CheckDlgButton( hDialog, IDC_CHECK_M103C, !GET_DWORD_BIT( CmdBuf[3], 1) );
                        CheckDlgButton( hDialog, IDC_CHECK_WDTON1, !GET_DWORD_BIT( CmdBuf[3], 0) );
                    }

                    CmdBuf[0] = 0x58;                          // ˿λ
                    CmdBuf[1] = 0x08;
                    CmdBuf[2] = 0x00;
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
                    {
                        MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                            MB_OK | MB_ICONEXCLAMATION);
                        return TRUE;
                    }
                    //MHEX( CmdBuf, 4, "2" );
                    CheckDlgButton( hDialog, IDC_CHECK_RSTD,  !GET_DWORD_BIT( CmdBuf[3], 7) );
                    CheckDlgButton( hDialog, IDC_CHECK_WDTON, !GET_DWORD_BIT( CmdBuf[3], 6) );
                    CheckDlgButton( hDialog, IDC_CHECK_SPIEN, !GET_DWORD_BIT( CmdBuf[3], 5) );
                    CheckDlgButton( hDialog, IDC_CHECK_CKOPT, !GET_DWORD_BIT( CmdBuf[3], 4) );
                    CheckDlgButton( hDialog, IDC_CHECK_EESAVE,  !GET_DWORD_BIT( CmdBuf[3], 3) );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTSZ1, !GET_DWORD_BIT( CmdBuf[3], 2) );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTSZ0, !GET_DWORD_BIT( CmdBuf[3], 1) );
                    CheckDlgButton( hDialog, IDC_CHECK_BOOTRST, !GET_DWORD_BIT( CmdBuf[3], 0) );

                    CmdBuf[0] = 0x50;                       // ˿λ
                    CmdBuf[1] = 0x00;
                    CmdBuf[2] = 0x00;
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
                    {
                        MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                            MB_OK | MB_ICONEXCLAMATION );
                        return TRUE;
                    }
                    //MHEX( CmdBuf, 4, "3" );
                    CheckDlgButton( hDialog, IDC_CHECK_BODLEVEL, !GET_DWORD_BIT( CmdBuf[3], 7) );
                    CheckDlgButton( hDialog, IDC_CHECK_BODEN, !GET_DWORD_BIT( CmdBuf[3], 6) );
                    CheckDlgButton( hDialog, IDC_CHECK_SUT1,  !GET_DWORD_BIT( CmdBuf[3], 5) );
                    CheckDlgButton( hDialog, IDC_CHECK_SUT0,  !GET_DWORD_BIT( CmdBuf[3], 4) );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL3, !GET_DWORD_BIT( CmdBuf[3], 3) );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL2, !GET_DWORD_BIT( CmdBuf[3], 2) );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL1, !GET_DWORD_BIT( CmdBuf[3], 1) );
                    CheckDlgButton( hDialog, IDC_CHECK_CKSEL0, !GET_DWORD_BIT( CmdBuf[3], 0) );
                    if( wmEvent != 0xffff )
                    {   // һδ򿪲Ի
                        _stprintf( CharBUf, _T("%sóɹ!"), McuName[McuType] );
                        MessageBoxCenter( hDialog, CharBUf, _T(APPNAME), MB_OK | MB_ICONINFORMATION );
                    }
                    else
                    {
                        _stprintf( CharBUf, _T("%s ü"), McuName[McuType] );
                        SetWindowText( hDialog, CharBUf );
                    }
                }
                return TRUE;

                case IDC_WRITE_CONG:
                {
                    //ȡ־λдMCU
                    CmdBuf[3] = 0XFF;       //ĬȫΪ1Ϊδ
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BLOCk12 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 5 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BLOCk11 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 4 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BLOCk02 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 3 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BLOCk01 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 2 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_LOCK2 )== BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 1 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_LOCK1 )== BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 0 );

                    CmdBuf[0] = 0xAC;                       // дλ
                    CmdBuf[1] = 0xE0;
                    CmdBuf[2] = 0x00;
                    //MHEX( CmdBuf, 4, "1" );
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
                    {
                        MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                            MB_OK | MB_ICONEXCLAMATION);
                        return TRUE;
                    }
                    Sleep( 20 );                            // ٵȴ4.5ms

                    if( McuType == ATMEL_MEGA128_MODEL || ( McuType == ATMEL_MEGA48_MODEL )
                        || ( McuType == ATMEL_MEGA88_MODEL ) || ( McuType == ATMEL_MEGA128_MODEL ))
                    {
                        CmdBuf[3] = 0XFF;                   // ĬȫΪ1Ϊδ
                        if( IsDlgButtonChecked( hDialog, IDC_EXPAND_SET2 ) == BST_CHECKED )
                            CLR_DWORD_BIT( CmdBuf[3], 2 );
                        if( IsDlgButtonChecked( hDialog, IDC_CHECK_M103C ) == BST_CHECKED )
                            CLR_DWORD_BIT( CmdBuf[3], 1 );
                        if( IsDlgButtonChecked( hDialog, IDC_CHECK_WDTON1 ) == BST_CHECKED )
                            CLR_DWORD_BIT( CmdBuf[3], 0 );

                        CmdBuf[0] = 0xAC;                   // дչ˿λ
                        CmdBuf[1] = 0xA4;
                        CmdBuf[2] = 0x00;
                        //MHEX( CmdBuf, 4, "2" );
                        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
                        {
                            MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                                MB_OK | MB_ICONEXCLAMATION);
                            return TRUE;
                        }
                        Sleep( 20 );
                    }

                    CmdBuf[3] = 0XFF;                       // ĬȫΪ1Ϊδ
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_RSTD ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 7 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_WDTON ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 6 );
                                                            // ûжSPIENλ
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_CKOPT ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 4 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_EESAVE ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 3 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BOOTSZ1 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 2 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BOOTSZ0 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 1 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BOOTRST ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 0 );

                    CmdBuf[0] = 0xAC;                       // ˿λ
                    CmdBuf[1] = 0xA8;
                    CmdBuf[2] = 0x00;
                    //MHEX( CmdBuf, 4, "2" );
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
                    {
                        MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                            MB_OK | MB_ICONINFORMATION );
                        return TRUE;
                    }
                    Sleep( 20 );                                 // ٵȴ4.5ms

                    CmdBuf[3] = 0XFF;                           // ĬȫΪ1Ϊδ
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BODLEVEL ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 7 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_BODEN ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 6 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_SUT1 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 5 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_SUT0 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 4 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_CKSEL3 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 3 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_CKSEL2 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 2 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_CKSEL1 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 1 );
                    if( IsDlgButtonChecked( hDialog, IDC_CHECK_CKSEL0 ) == BST_CHECKED )
                        CLR_DWORD_BIT( CmdBuf[3], 0 );

                    CmdBuf[0] = 0xAC;                           // ˿λ
                    CmdBuf[1] = 0xA0;
                    CmdBuf[2] = 0x00;
                    //MHEX( CmdBuf, 4, "3" );
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
                    {
                        MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                            MB_OK | MB_ICONINFORMATION );
                        return TRUE;
                    }
                    Sleep( 20 );                                 // ٵȴ4.5ms

                    _stprintf( CharBUf, _T("%sдóɹ!"), McuName[McuType] );
                    MessageBoxCenter( hDialog, CharBUf, _T(APPNAME), MB_OK | MB_ICONINFORMATION );
                }
                return TRUE;

                case IDC_CLOSE:
                {
                     EndDialog( hDialog, 0);
                }
                return TRUE;
            }
        }
        return TRUE;

        case WM_CLOSE:
            EndDialog( hDialog, 0);                         // رնԻ,0
        return TRUE;
    }
    return FALSE;
}


/*==============================================================================

: S51SetMcuConfig

: S51öԻص

==============================================================================*/
LRESULT CALLBACK S51SetMcuConfig( HWND hDialog, UINT uMessage, WPARAM wParam, LPARAM lParam )
{
INT wmId, wmEvent;
UCHAR CmdBuf[32];
TCHAR CharBUf[32];
UINT i, k;

    switch( uMessage )
    {
        case WM_INITDIALOG:
        {
            // ĬϿʼ
            SendMessage( hDialog, WM_COMMAND, MAKELONG(IDC_READ_CONG, 0XFFFF), 0 );
            SetWindowCenter( hDialog );
        }
        return TRUE;

        case WM_COMMAND:
        {
            wmId = LOWORD(wParam);
            wmEvent = HIWORD(wParam);
            switch( wmId )
            {
                case IDC_READ_CONG:
                {
                    CmdBuf[0] =0X24;                // Read Lock Bits
                    if( At89sISPoutin( Ch341index, 3, CmdBuf, 1, CmdBuf ) == FALSE )
                    {
                        MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                            MB_OK | MB_ICONINFORMATION );
                        return TRUE;
                    }
                    //MHEX( CmdBuf, 1, "CmdBuf[0]" );
                    if( ((CmdBuf[0] >> 2) & 0x07) & 0x04 )
                    {
                        CheckRadioButton( hDialog, IDC_RADIO1, IDC_RADIO4,
                        IDC_RADIO4 );
                    }
                    else  if( ((CmdBuf[0] >> 2) & 0x07) & 0x02 )
                    {
                        CheckRadioButton( hDialog, IDC_RADIO1, IDC_RADIO4,
                        IDC_RADIO3);
                    }
                    else  if( ((CmdBuf[0] >> 2) & 0x07) & 0x01 )
                    {
                        CheckRadioButton( hDialog, IDC_RADIO1, IDC_RADIO4,
                        IDC_RADIO2);
                    }
                    else
                    {
                        CheckRadioButton( hDialog, IDC_RADIO1, IDC_RADIO4,
                        IDC_RADIO1 );
                    }

                    if( wmEvent != 0xffff )
                    {   // һδ򿪲Ի
                        _stprintf( CharBUf, _T("%sóɹ!"), McuName[McuType] );
                        MessageBoxCenter( hDialog, CharBUf, _T(APPNAME), MB_OK | MB_ICONINFORMATION );
                    }
                    else
                    {
                        _stprintf( CharBUf, _T("%s ü"), McuName[McuType] );
                        SetWindowText( hDialog, CharBUf );
                    }
                }
                return TRUE;

                case IDC_WRITE_CONG:
                {
                    for( i=0; i!=4; i++ )
                    {
                        if( IsDlgButtonChecked( hDialog, (IDC_RADIO1 + i) ) == BST_CHECKED )
                            break;
                    }
                    // iֵ趨־λ
                    for( k=0; k<=i; k++ )
                    {
                        CmdBuf[0] = 0xAC;               // Write Lock Bits
                        CmdBuf[1] = ( 0xE0 | (UCHAR)k );
                        //MHEX( &CmdBuf[1], 1, "CmdBuf" );
                        if ( At89sISPoutput( Ch341index, 4, CmdBuf ) == FALSE )
                        {
                            MessageBoxCenter( hDialog, _T("ݴʧ"), _T(APPNAME),
                                MB_OK | MB_ICONINFORMATION);
                            return TRUE;
                        }
                        Sleep( 5 );
                    }
                    _stprintf( CharBUf, _T("д%sóɹ!"), McuName[McuType] );
                    MessageBoxCenter( hDialog, CharBUf, _T(APPNAME), MB_OK | MB_ICONINFORMATION );
                }
                return TRUE;

                case IDC_CLOSE:
                {
                     EndDialog( hDialog, 0);
                }
                return TRUE;
            }
        }
        return TRUE;

        case WM_CLOSE:
            EndDialog( hDialog, 0);                         // رնԻ,0
        return TRUE;
    }
    return FALSE;
}

/*==============================================================================

: mDialogMain

: Իص

==============================================================================*/
LRESULT CALLBACK mDialogMain( HWND hDialog, UINT uMessage, WPARAM wParam, LPARAM lParam )
{
INT wmId, wmEvent;
ULONG i;
MENUITEMINFO mi;

    switch( uMessage )
    {
        case WM_INITDIALOG:
        {
            MainDialog = hDialog;
            // ʼϵͳ˵
            hSysMenu = GetSystemMenu( hDialog, FALSE );
            RtlZeroMemory( &mi, sizeof(mi) );
            mi.cbSize       = sizeof( mi );
            mi.fMask        = MIIM_ID | MIIM_TYPE;
            mi.wID          = IDC_SET_SPI;
            mi.dwTypeData   = "MEGAʹÿ(&S)";
            InsertMenuItem( hSysMenu, SC_CLOSE, FALSE, &mi );

            RtlZeroMemory( &mi, sizeof(mi) );
            mi.cbSize       = sizeof( mi );
            mi.fMask        = MIIM_ID | MIIM_TYPE;
            mi.wID          = IDC_CMD_HELP;
            mi.dwTypeData   = "(&H)";
            InsertMenuItem( hSysMenu, SC_CLOSE, FALSE, &mi );

            RtlZeroMemory( &mi, sizeof(mi) );
            mi.cbSize       = sizeof( mi );
            mi.fMask        = MIIM_TYPE;
            mi.fType        = MFT_SEPARATOR;
            InsertMenuItem( hSysMenu, SC_CLOSE, FALSE, &mi );

            // ñͼ
            SendMessage( hDialog, WM_SETICON, ICON_BIG, 
                (LPARAM)LoadIcon( DownExeHins, (LPCTSTR)IDI_ICON1 ) );
            // ļʾ
            if( FileOpenBit )
                ShowTitleName( );
            else
                SetWindowText( hDialog, _T( APPNAME " "APPVER " - http:\\\\wch.cn" ) );

            // ʼ
            HwndProg = GetDlgItem( hDialog, IDC_DOWN_PROGRESS );
            SendMessage( HwndProg, PBM_SETRANGE,
                (WPARAM)0, (LPARAM)(MAKELPARAM( 0, MAX_PROG_LEN )) );
            SendMessage( HwndProg, PBM_SETPOS, (WPARAM)DownProgRange.iLow, (LPARAM)0 );
            
            // ʼ˵
            for( i=0; i!=MCU_COUNT; i++ )
                SendDlgItemMessage( hDialog, IDC_MCU_MODEL, CB_ADDSTRING, 0, (LPARAM)McuName[i] );
            SendDlgItemMessage( hDialog, IDC_MCU_MODEL, CB_SETCURSEL,ReadMcuIndexReg( ), 0 );
            if( CmdMode )
                SendDlgItemMessage( hDialog, IDC_MCU_MODEL, CB_SETCURSEL, McuType, 0 );
            // EEPRAMѡ
            EnableWindow( GetDlgItem( hDialog, IDC_EPRAM ), 1 );
            i = SendDlgItemMessage( hDialog, IDC_MCU_MODEL, CB_GETCURSEL, 0, 0 ); 
            if(i >= ATMEL_AT89S51_MODEL)
            {
                CheckDlgButton( hDialog, IDC_EPRAM, BST_UNCHECKED );
                EnableWindow( GetDlgItem( hDialog, IDC_EPRAM ), 0 );
            }

            // λ
            ReadWindowPosReg( );

            // 豸
            for( i=0; i!=mCH341_MAX_NUMBER; i++)
            {
                Ch341index = i;
                IniCh341Device( );
                if( Ch341State == TRUE )
                {
                    if( CmdMode )
                    {
                        if( McuCmd == WRITE_FLASH_CMD )
                            SendMessage( hDialog, WM_COMMAND, MAKELONG(IDC_BUTTON_DOWN, 0), 0 );
                        else if( McuCmd == WRITE_EEPROM_CMD )
                        {
                            CheckDlgButton( hDialog, IDC_EPRAM, BST_CHECKED );
                            SendMessage( hDialog, WM_COMMAND, MAKELONG(IDC_BUTTON_DOWN, 0), 0 );
                        }
                        else if( McuCmd == RESET_MCU_CMD )
                            SendMessage( hDialog, WM_COMMAND, MAKELONG(IDC_RUNING, 0), 0 );
                    }
                    break;
                }
            }

            if( CH341SetDeviceNotify( 0, (PCHAR)0,  CH341DP_NOTIFY_ROUTINE ) )
            {
                if( Ch341State == FALSE)                        // 豸ûб򿪣ʼ豸
                    SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ڼCH341豸...") );
            }
            else
                SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("CH341豸ʧ") );
        }
        return TRUE;

        case WM_SYSCOMMAND:
        {
            if( wParam == IDC_SET_SPI )
            {
                i = GetMenuState( hSysMenu, IDC_SET_SPI, MF_BYCOMMAND );
                if( i == MF_CHECKED )
                {
                    i = MF_UNCHECKED;
                    CH341SPIBitSet = FALSE;
                }
                else
                {
                    i = MF_CHECKED;
                    CH341SPIBitSet = TRUE;
                }
                CheckMenuItem( hSysMenu, IDC_SET_SPI, i );
                SetSpiRegConfig( );
                return TRUE;
            }
            else if( wParam == IDC_CMD_HELP )
            {
                MessageBoxCenter( hDialog, CH341DP_HELP_STR, _T(APPNAME), MB_OK | MB_ICONINFORMATION );
                return TRUE;
            }
            return FALSE;
        }

        case WM_COMMAND:
        {
            wmId = LOWORD(wParam);
            wmEvent = HIWORD(wParam);
            switch( wmId )
            {
                case IDC_MCU_MODEL:
                {
                    if( Downhandle == INVALID_HANDLE_VALUE)
                    {
                        McuType = SendDlgItemMessage( hDialog, IDC_MCU_MODEL, CB_GETCURSEL, 0, 0 ); 
                        EnableWindow( GetDlgItem( hDialog, IDC_EPRAM ), 1 );
                        if(McuType >= ATMEL_AT89S51_MODEL)
                        {                                           // AT89SϵûEEPROM
                            CheckDlgButton( hDialog, IDC_EPRAM, BST_UNCHECKED );
                            EnableWindow( GetDlgItem( hDialog, IDC_EPRAM ), 0 );
                        }
                    }
                }
                return TRUE;

                case IDC_SET_CONFIG:
                {
                    if( Downhandle == INVALID_HANDLE_VALUE)
                    {
                        McuType = SendDlgItemMessage( hDialog, IDC_MCU_MODEL,
                            CB_GETCURSEL, 0, 0 );                   // õMCUѡ
                        i = IniMcuDown( );
                        if( i == DATA_TRANS_ERR )
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ݴʧ") );
                            return TRUE;
                        }
                        else if( i == NO_MCU_ERR )                  // ޷ʶMCU
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("޷ʶMCU") );
                            return TRUE;
                        }
                        else if( i == MCU_MODEL_ERR )                // MCUɱ
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("MCUͺ") );
                            return TRUE;
                        }
                        else if( i == NO_SUPORT_ERR )
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ִ֧MCU") );
                            return TRUE;
                        }

                        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ɶMCUͺŵʶ") );
                        if( ( McuType >AUTO_MCU_MODEL ) && ( McuType < ATMEL_AT89S51_MODEL) )
                        {
                            DialogBox( DownExeHins, (LPCTSTR)IDD_SETCON_DIALOG,
                                hDialog, MegaSetMcuConfig );
                        }
                        else                                        // ΪAT89Sϵ
                        {
                            DialogBox( DownExeHins, (LPCTSTR)IDD_AT89SX_SET,
                                hDialog, S51SetMcuConfig );
                        }
                    }
                }
                return TRUE;

                case IDC_RUNING:
                {
                    if( Downhandle == INVALID_HANDLE_VALUE)
                    {
                        SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ڸλоƬ...") );
                        McuType = SendDlgItemMessage( hDialog, IDC_MCU_MODEL,
                            CB_GETCURSEL, 0, 0 );                   // õMCUѡ
                        i = IniMcuDown( );
                        if( i == DATA_TRANS_ERR )
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ݴʧ") );
                            return TRUE;
                        }
                        else if( i == NO_MCU_ERR )                  // ޷ʶMCU
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("޷ʶMCU") );
                            return TRUE;
                        }
                        else if( i == MCU_MODEL_ERR )                // MCUɱ
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("MCUͺ") );
                            return TRUE;
                        }
                        else if( i == NO_SUPORT_ERR )
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ִ֧MCU") );
                            return TRUE;
                        }

                        if( (McuType >AUTO_MCU_MODEL ) && (McuType < ATMEL_AT89S51_MODEL) )
                            i = SpiRunMega( Ch341index );
                        else
                            i = SpiRunAt89s( Ch341index );

                        if( i == TRUE )
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("λMCUɹ") );
                        else
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ݴʧ") );
                    }
                }
                return TRUE;

                case IDC_BUTTON_BROWER:
                {
                OPENFILENAME mOpenFile;

                    if( Downhandle == INVALID_HANDLE_VALUE)
                    {
                        RtlZeroMemory( &mOpenFile, sizeof( mOpenFile ) );
                        mOpenFile.lStructSize       = sizeof(OPENFILENAME);
                        mOpenFile.hwndOwner         = hDialog;
                        mOpenFile.hInstance         = DownExeHins;
                        mOpenFile.lpstrFilter       = _T("ļ(*.HEX *.BIN)\0*.HEX;*.BIN\0ļ(*.*)\0*.*\0");
                        mOpenFile.lpstrFile         = DownFileBuf;
                        mOpenFile.nMaxFile          = sizeof(DownFileBuf);
                        mOpenFile.lpstrTitle        = _T("ѡصĿļ");
                        mOpenFile.Flags             = OFN_EXPLORER | OFN_READONLY | OFN_FILEMUSTEXIST;
                        if( GetOpenFileName( &mOpenFile ) )     //ļ·ռ
                        {                                       //ʾʾ
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, DownFileBuf );
                            ShowTitleName( );
                            EnableWindow( GetDlgItem( MainDialog, IDC_BUTTON_DOWN ), 1 );
                            FileOpenBit = TRUE;
                        }
                    }
                }
                return TRUE;

                case IDC_EPRAM:
                {
                    if( Downhandle == INVALID_HANDLE_VALUE)
                    {
                        if( IsDlgButtonChecked( hDialog, IDC_EPRAM ) == BST_CHECKED )
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ݵEEPROM") );
                        else
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ݵFLASH") );
                    }
                }
                return TRUE;

                case IDC_BUTTON_DOWN:
                {
                    if( Downhandle == INVALID_HANDLE_VALUE)
                    {
                        McuType = SendDlgItemMessage( hDialog, IDC_MCU_MODEL,
                            CB_GETCURSEL, 0, 0 );               // õMCUѡ

                        IsEepromData = FALSE;
                        if( IsDlgButtonChecked( hDialog, IDC_EPRAM ) == BST_CHECKED )
                            IsEepromData = TRUE;

                        StopBit = FALSE;
                        Downhandle = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)_DownThread,
                            hDialog, 0, &i );
                        if(Downhandle == NULL)
                        {
                            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("߳ʧ") );
                            Downhandle = INVALID_HANDLE_VALUE;
                        }
                        else
                            CloseHandle( Downhandle );
                    }
                    else //ֹͣ
                    {
                        StopBit = TRUE;
                        SetDlgItemText( hDialog, IDC_BUTTON_DOWN, _T( "" ) );
                    }
                }
                return TRUE;

                case IDCANCEL:
                case IDC_QUIT:
                {
                    SendMessage( hDialog, WM_CLOSE, 0, 0 );
                    return TRUE;
                }
            }
        }
        return FALSE;       // ûдϢش

        case WM_CLOSE:
        {
            if( Downhandle != INVALID_HANDLE_VALUE)
            {
                if(IDNO == MessageBoxCenter( hDialog, _T(",ȷ˳?"),
                    _T(APPNAME), MB_YESNO | MB_ICONQUESTION  ) )
                    return TRUE;
            }
            if( Ch341State == TRUE )
                CH341CloseDevice( Ch341index );             // ر豸

            #if 1
            StopBit = TRUE;
            SetDlgItemText( hDialog, IDC_STATIC_PROMPT, _T("ȴֹͣ...") );
            //Sleep( 10 );

            WriteWindowPosReg( );
            McuType = SendDlgItemMessage( hDialog, IDC_MCU_MODEL, CB_GETCURSEL, 0, 0 );
            SetMcuIndexReg( McuType );
            #endif

            EndDialog( hDialog, 0);                         // رնԻ,0
            return TRUE;
        }

        default:
            return FALSE;
    }
}

/*==============================================================================

: AnalyseCmdLine

:  в

 0 棬 1ģʽȡɹ 2 

==============================================================================*/
ULONG  AnalyseCmdLine( LPSTR lpCmdLine )
{
ULONG len;
PVOID p1, p2;
CHAR  *d;
UCHAR CmdBuf[256];
UCHAR FileBuf[256];             // ļ·
UCHAR MCUbuf[16];               // MCUֻ
TCHAR MCUbufW[16];              // תUNICODEŻ
BOOL   Fbit;                    // ļ·־

    len = strlen( lpCmdLine );
    if( len == 0 )                  // û
        return CMD_NORMAL;
    if( len > sizeof(CmdBuf) - 1  )
        goto PERR;

    McuType = MCU_COUNT;            // ЧMCU
    Fbit = FALSE;
    d = " ";
    memcpy( CmdBuf, lpCmdLine, strlen(lpCmdLine) + 1 );
    strupr( CmdBuf );               // Сдĸתɴд

    p1 = strchr( CmdBuf , '\"' );   // ",ȡļַ
    if( p1 != NULL )
    {
        p2 = strchr( (PUCHAR)p1 + 1 , '\"' );
        if( p2 != NULL )
        {
            *(PUCHAR)p2 = 0;
            *(PUCHAR)p1 = 0;
            memcpy( FileBuf, (PUCHAR)p1 + 1, strlen((PUCHAR)p1 + 1) + 1 );
            #ifdef  UNICODE
            MultiByteToWideChar( CP_ACP, 0, FileBuf, strlen(FileBuf) + 1,
                &DownFileBuf[0], SIZE(DownFileBuf) );
            #else
            strcpy( DownFileBuf, FileBuf );
            #endif
            FileOpenBit = TRUE;
            Fbit = TRUE;
            //MessageBoxCenterW( NULL, DownFileBuf, _T("", MB_OK );
        }
        else
            goto PERR;
    }

    // ѵһոΪ0
    p1 = strtok( CmdBuf, d );
    if( p1 != NULL )
    {
        len = strlen( p1 );
        if( len < ( sizeof(MCUbuf) - 1 )  )
        {
            memcpy( MCUbuf, p1, strlen(p1) + 1 );
            #ifdef  UNICODE
            MultiByteToWideChar( CP_ACP, 0, MCUbuf, strlen(MCUbuf) + 1,
                MCUbufW, SIZE(MCUbufW) );
            #else
            strcpy( MCUbufW, MCUbuf );
            #endif

            if( strcmp( MCUbufW, _T("MEGA") )  == 0 )
                McuType = 0;
            else
            {
                for( len=1; len<MCU_COUNT; len++ )
                {
                    if( strcmp( McuName[len], MCUbufW ) == 0 )
                    {
                        McuType = len;
                        break;
                    }
                }
            }

            if( McuType == MCU_COUNT )
                goto PERR;
            //MessageBoxCenterW( NULL, MCUbufW, _T("", MB_OK );
        }
        else
           goto PERR;
        p1 = strtok( NULL,d );
    }
    else
       goto PERR;

    // ѵڶոΪ0
    if( p1 != NULL )
    {
        len = strlen( p1 );
        if( len == sizeof(McuCmd) )
        {
            McuCmd = MAKEWORD( (*((PUCHAR)p1+1)), (*(PUCHAR)p1) );
            if( McuCmd == WRITE_FLASH_CMD )
            {
                if( Fbit == FALSE )
                    goto PERR;
            }
            else if( McuCmd == WRITE_EEPROM_CMD )
            {
                if( Fbit == FALSE )
                    goto PERR;
                
                if( McuType >= ATMEL_AT89S51_MODEL )    // AT89SûEEPROMΪFLASH
                    goto PERR;
            }
            else if( McuCmd == RESET_MCU_CMD )
            {
                if( Fbit == TRUE )
                    goto PERR;
            }
            else
                goto PERR;
        }
        else
            goto PERR;
        p1 = strtok( NULL,d );
    }
    else
        goto PERR;

    if( p1 != NULL )            // Ӧûпո
        goto PERR;

    CmdMode = TRUE;
    return CMD_START;

    PERR:
    MessageBox( NULL, CH341DP_HELP_STR, _T(APPNAME), MB_OK | MB_ICONINFORMATION );
    return CMD_ERROR;
}

/*==============================================================================

: WinMain

:  

==============================================================================*/
INT APIENTRY    WinMain( HINSTANCE hInstance, HINSTANCE hPrevInst,
                        LPSTR lpCmdLine, INT nShowCmd )
{
ULONG i;

    Downhandle = INVALID_HANDLE_VALUE;              // ʼȫֱ
    DownExeHins = hInstance;                        // ʵ
    Ch341index = 0;                                 // Ĭϴ0豸ʼ
    McuType = 0;                                    // ĬѡMEGA AUTO
    CmdMode = FALSE;                                // Ĭϲģʽ
    FileOpenBit = FALSE;                            // ļ򿪱־λ
    
    //lpCmdLine = "mega WF \"Video_Module.hex\" ";
    //lpCmdLine = "at89s51 wf \"0.BIN\" ";
    //lpCmdLine = "at89s51 rm ";
    
    i = AnalyseCmdLine( lpCmdLine );
    if( i == CMD_ERROR )
        return 1;
    InitCommonControls( );
    DialogBox( hInstance, (LPCTSTR)IDD_CH341DP_DIALOG, NULL, mDialogMain );
    return 0;
}
