#include    <windows.h>
#include    <tchar.h>
#include    <commctrl.h>
#include    "ch341dp.h"
#include    "CH341IO.H"
#include    "CH341DLL.H"
#include    "resource.h"
#include    "MSHOW.H"

const PTCHAR McuName[ ] = { _T("MEGA AUTO"), _T("MEGA8"), _T("MEGA16"), _T("MEGA32"), 
    _T("MEGA64"), _T("MEGA128"), _T("MEGA8515"), _T("MEGA8535"), _T("MEGA48"), 
    _T("MEGA88"), _T("MEGA168"), _T("AT89S51"), _T("AT89S52") };

/*==============================================================================

: MegaSpiEnable

: CH341SPI,D1ΪS_RST D3ΪS_CLK D5ΪS_MOSI D7ΪS_MOSO

==============================================================================*/
BOOL    WINAPI  MegaSpiEnable( ULONG index )
{
UCHAR   mBuffer[ mCH341_PACKET_LENGTH ];
ULONG   i;

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | 0x00;    // default status: all 0
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_DIR | 0x2A;    // D1 & D3 & D5 output, other input
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 32;       // ʱ32΢
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;           // ǰǰ
    return( CH341WriteData( index, mBuffer, &i ) );     // ִ
}

/*==============================================================================

: S51SpiEnable

: CH341SPI,D1ΪS_RST D3ΪS_CLK D5ΪS_MOSI D7ΪS_MOSO

==============================================================================*/
BOOL    WINAPI  S51SpiEnable(
    ULONG       index )  // ָCH341豸
{
    UCHAR   mBuffer[ mCH341_PACKET_LENGTH ];
    ULONG   i;
    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | 0x02;    // D1 =1 other status: all 0
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_DIR | 0x2A;    // D1 & D3 & D5 output, other input
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 32;       // ʱ32΢
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;           // ǰǰ
    return( CH341WriteData( index, mBuffer, &i ) );     // ִ
}

/*==============================================================================

: SpiRunMega

: MEGA MCU УͬʱSPIΪ̬

==============================================================================*/
BOOL WINAPI SpiRunMega( ULONG   index )
{
UCHAR   mBuffer[ mCH341_PACKET_LENGTH ];
ULONG   i;

    if( MegaSpiEnable(index) == FALSE )
        return FALSE;

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT |0x02;     // D1=1
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;
    if(CH341WriteData( index, mBuffer, &i ) == FALSE )
        return FALSE;

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT |0x00;     // D1=0
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;
    if(CH341WriteData( index, mBuffer, &i ) == FALSE )
        return FALSE;

	i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT |0x02;     // D1=1
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;
    if(CH341WriteData( index, mBuffer, &i ) == FALSE )
        return FALSE;
	// ϲ͵ƽλMCU

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | 0xff;    // all status: 1
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_DIR | 0x00;    // ȫ
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;           // ǰǰ
    return( CH341WriteData( index, mBuffer, &i ) );     // ִ
}

/*==============================================================================

: SpiRunAt89s

: At89s MCU УͬʱSPIΪ̬

==============================================================================*/
BOOL WINAPI SpiRunAt89s( ULONG   index )
{
UCHAR   mBuffer[ mCH341_PACKET_LENGTH ];
ULONG   i;

    if( S51SpiEnable(index) == FALSE )
        return FALSE;

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT |0x00;     // D1=0
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;
    if(CH341WriteData( index, mBuffer, &i ) == FALSE )
        return FALSE;

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT |0x02;     // D1=1
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;
    if(CH341WriteData( index, mBuffer, &i ) == FALSE )
        return FALSE;

	i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT |0x00;     // D1=0
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;
    if(CH341WriteData( index, mBuffer, &i ) == FALSE )
        return FALSE;
	// ϲߵƽλMCU

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | 0xfD;    // all status: 1
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_DIR | 0x02;    // ȫ
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;           // ǰǰ
    return( CH341WriteData( index, mBuffer, &i ) );     // ִ
}

/*==============================================================================

: SpiResetAT89s

: SPIAT89Sλ
==============================================================================*/
BOOL    WINAPI  SpiResetAT89s(
    ULONG       index )  // ָCH341豸
{
    UCHAR   mBuffer[ mCH341_PACKET_LENGTH ];
    ULONG   i;
    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | 0x00;    // status: all 0
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_DIR | 0x2A;    // D1 & D3 & D5 output, other input
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;           // ǰǰ
    return( CH341WriteData( index, mBuffer, &i ) );     // ִ
}

/*==============================================================================

: SpiResetMega

: SPImegaλ(һ()ʹMCUλ)

==============================================================================*/
BOOL    WINAPI  SpiResetMega( ULONG   index )
{
UCHAR  mBuffer[ mCH341_PACKET_LENGTH];
ULONG i;

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT |0x02;     // D1=1
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;
    if(CH341WriteData( index, mBuffer, &i ) == FALSE )
        return FALSE;

    i = 0;
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;            // 
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT |0x00;     // D1=0
    mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;
    return (CH341WriteData( index, mBuffer, &i ) );
}

#define     DELAY_US        4
/*==============================================================================

: MegaSpiOutInData

: ݵMCU,ͬʱõ

==============================================================================*/
BOOL    WINAPI  MegaSpiOutInData(
    ULONG   index,          // ָCH341豸
    ULONG   OutLen,         // ݳ
    PVOID   DataBuf,        // ݻSPIݷع
    BOOL    SpiBit )       // ǷʹSPI4
{
PUCHAR p;
ULONG i, j, k;
UCHAR c, tem;
UCHAR  mBuffer[ 512 ];

    // 202334066 + 6.95us - 5.85us
    //SpiBit = FALSE;
    if( !SpiBit )
    {
        p = DataBuf;
        k = 0;
        for( i = 0; i != OutLen; i++ )
        {
            tem = *p;
            mBuffer[ k++ ] = mCH341A_CMD_UIO_STREAM;            // 
            for( j = 0; j != 4; j++ )
            {
                c = tem & 0x80 ? 0x20 : 0;                              // D5 
                mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_OUT | c;           // D3=0, I/O_CLOCK=LOW 
                mBuffer[ k++ ] =mCH341A_CMD_UIO_STM_US | DELAY_US;       
                mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_OUT | c | 0x08;    // D3=1, I/O_CLOCK=HIGH
                mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_IN;                // input from D7
                mBuffer[ k++ ] =mCH341A_CMD_UIO_STM_US | DELAY_US;
                tem <<= 1;
            }
            mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_OUT | c | 0x00;        // D3=0, I/O_CLOCK=LOW
            mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_END;                   // ǰǰ
            k += mCH341_PACKET_LENGTH - 1;
            k &= ~ ( mCH341_PACKET_LENGTH - 1 );

            mBuffer[ k++ ] = mCH341A_CMD_UIO_STREAM;            // 
            for( j = 0; j != 4; j++ )
            {
                c = tem & 0x80 ? 0x20 : 0;                              // D5 
                mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_OUT | c;           // D3=0, I/O_CLOCK=LOW        
                mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_US | DELAY_US; 
                mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_OUT | c | 0x08;    // D3=1, I/O_CLOCK=HIGH
                mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_IN;                // input from D7
                mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_US | DELAY_US;
                tem <<= 1;
            }
            mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_OUT | c | 0x00;        // D3=0, I/O_CLOCK=LOW
            mBuffer[ k++ ] = mCH341A_CMD_UIO_STM_END;                   // ǰǰ
            k += mCH341_PACKET_LENGTH - 1;
            k &= ~ ( mCH341_PACKET_LENGTH - 1 );
            p++;
        }

        i = CH341WriteRead( index, k, mBuffer, 4, OutLen*2, &j, mBuffer );
        if( i == FALSE )
            return( FALSE );

        if( j != OutLen * 8 )
            return( FALSE );

        k = 0;
        for ( i = 0; i != OutLen; i++ )
        {
            c = 0;
            for ( j = 0; j < 8; j ++ )
            {
                c <<= 1;
                if ( mBuffer[ k++ ] & 0x80 )        // input 8 bit
                    c ++;
            }

            *(PUCHAR)DataBuf = c;
            ((PUCHAR)DataBuf)++;
        }
        return TRUE;
    }
    else
    {
        return CH341StreamSPI4( index, 0x00, OutLen, DataBuf );
    }
}

/*==============================================================================

: At89sISPoutput

: ݵMCU

==============================================================================*/
BOOL    WINAPI  At89sISPoutput(
    ULONG       index,      // ָCH341豸
    ULONG   OutLen,         // ݳ
    LPCSTR  OutBuf )        // ݻ
{
UCHAR   mBuffer[ mCH341_PACKET_LENGTH * 128 ];
UCHAR   c, cmd, tem;
ULONG   cnt, i, j;
ULONG   ThisLen;
cmd = *OutBuf;

    while ( OutLen )
    {
        ThisLen = OutLen > 128 ? 128 : OutLen;
        OutLen -= ThisLen;
        i = 0;
        for ( cnt = 0; cnt < ThisLen; cnt++ )
        {
            mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;  // 
            tem = *OutBuf;
            for ( j = 0; j < 8; j ++ )
            {  // output 8 bit
                c = tem & 0x80 ? 0x20 : 0;  // D5
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | c | SET_CH341_D1;            // D3=0, I/O_CLOCK=LOW
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | c | 0x08 | SET_CH341_D1;     // D3=1, I/O_CLOCK=HIGH
                tem <<= 1;
            }
            OutBuf ++;
            mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | c | 0x00 | SET_CH341_D1;         // D3=0, I/O_CLOCK=LOW
            // delay for program byte
            if ( cmd == 0x50 )
            { // page write command
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢, 0-63
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_US | 63;  // ʱ63΢
            }  // delay > 500us

            mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;  // ǰǰ,ΪһŲ,Էֳ
            i += mCH341_PACKET_LENGTH - 1;
            i &= ~ ( mCH341_PACKET_LENGTH - 1 );
        }
        if ( CH341WriteData( index, mBuffer, &i ) == FALSE )
            return( FALSE );
    }
    return( TRUE );  // ִ
}

/*==============================================================================

: At89sISPoutin

: ݵMCUõ

==============================================================================*/
BOOL    WINAPI  At89sISPoutin(
    ULONG           index,  // ָCH341豸
    ULONG   OutLen,         //ݳ
    LPCSTR  OutBuf,         //ݻ
    ULONG   InLen,          //׼ȡݳ
    PUCHAR  InBuf )         //ݻ
{
UCHAR   mBuffer[ mCH341_PACKET_LENGTH * 128 ];
UCHAR   c,cmd;
ULONG   cnt, i, j, mLength;
ULONG   ThisLen;

    if ( OutLen > sizeof( mBuffer ) / 32 - 1 ) return( FALSE ); // buffer over
    i = 0;
    for ( cnt = 0; cnt < OutLen; cnt++ )
    {
        mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;  // 
        cmd = *OutBuf;
        for ( j = 0; j < 8; j ++ )
        {  // output 8 bit
            c = cmd & 0x80 ? 0x20 : 0;  // D5
            mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | c | SET_CH341_D1;  // D3=0, I/O_CLOCK=LOW
            mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | c | 0x08 | SET_CH341_D1;  // D3=1, I/O_CLOCK=HIGH
            cmd <<= 1;
        }
        OutBuf ++;
        mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | c | 0x00 | SET_CH341_D1;  // D3=0, I/O_CLOCK=LOW
        mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;  // ǰǰ,ΪһŲ,Էֳ
        i += mCH341_PACKET_LENGTH - 1;
        i &= ~ ( mCH341_PACKET_LENGTH - 1 );
    }
    while( InLen )
    {
        j = ( sizeof( mBuffer ) - i ) / 32;
        ThisLen = InLen > j ? j : InLen;
        InLen -= ThisLen;
        for ( cnt = 0; cnt < ThisLen; cnt++ )
        {
            mBuffer[ i++ ] = mCH341A_CMD_UIO_STREAM;  // 
            for ( j = 0; j < 8; j ++ )
            {  // input 8 bit
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | 0x08 | SET_CH341_D1;  // D3=1, I/O_CLOCK=HIGH
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_IN;  // input from D7
                mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_OUT | 0x00 | SET_CH341_D1;  // D3=0, I/O_CLOCK=LOW
            }
            mBuffer[ i++ ] = mCH341A_CMD_UIO_STM_END;  // ǰǰ,ΪһŲ,Էֳ
            i += mCH341_PACKET_LENGTH - 1;
            i &= ~ ( mCH341_PACKET_LENGTH - 1 );
        }
        mLength = 0;
        j = CH341WriteRead( index, i, mBuffer, 8, ThisLen, &mLength, mBuffer );
        // ִ,,ִ,ÿ8ֽ
        if ( j == FALSE ) return( FALSE );
        if ( mLength != ThisLen * 8 )
        {
            //printf("length=%d,%d\n",mLength,ThisLen);
            return( FALSE );  // size error
        }
        i = 0;
        for ( cnt = 0; cnt < ThisLen; cnt++ )
        {
            c = 0;
            for ( j = 0; j < 8; j ++ ) {  // input 8 bit
                c <<= 1;
                if ( mBuffer[ i++ ] & 0x80 ) c ++;
            }
            *InBuf = c;
            InBuf ++;
        }
        i = 0;
    }
    return( TRUE );
}

/*==============================================================================

: IniMcuDown

: ʼMEGAϵеMCU

==============================================================================*/
UCHAR WINAPI IniMcuDown( void )
{
UCHAR  CmdBuf[32];
UCHAR  tem8;

    if( (McuType >= AUTO_MCU_MODEL) && (McuType < ATMEL_AT89S51_MODEL) )
    {
        if( MegaSpiEnable( Ch341index ) == FALSE)   // ʼCH341SPI
            return DATA_TRANS_ERR;
        if( SpiResetMega(Ch341index ) == FALSE )
            return DATA_TRANS_ERR;                  // λMEGA8
        Sleep( 200 );                                // λʱ20ms

        CmdBuf[0] = 0xAC;                           // Programming Enable
        CmdBuf[1] = 0x53;
        CmdBuf[2] = 0xff;
        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
            return DATA_TRANS_ERR;
         if( CmdBuf[2] != 0x53 )
            return NO_MCU_ERR;                      // ޷ʶMCU

        CmdBuf[0] = 0x30;                           // Read Signature Bytes
        CmdBuf[1] = 0x00;
        CmdBuf[2] = 0x00;
        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
            return DATA_TRANS_ERR;
        //MHEX( CmdBuf, 4, "s0" );
        if( CmdBuf[3] != 0x1E )                     // IEΪʾAtmel ˾
            return MCU_MODEL_ERR;

        CmdBuf[0] = 0x30;                           // Read Signature Bytes
        CmdBuf[1] = 0x00;
        CmdBuf[2] = 0x01;
        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
            return DATA_TRANS_ERR;
        //MHEX( CmdBuf, 4, "s1" );
        if( McuType == AUTO_MCU_MODEL )             // ԶѡMCUʱ,ûFLASHռм
        {
            tem8 = CmdBuf[3];
            goto P_NEXT;
        }
        if( McuType == ATMEL_MEGA8_MODEL )
        {
            if( CmdBuf[3] != 0x93 )                 // ʾоƬ 8KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA16_MODEL )
        {
            if( CmdBuf[3] != 0x94 )                 // ʾоƬ 16KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA32_MODEL )
        {
            if( CmdBuf[3] != 0x95 )                 // ʾоƬ 32KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA64_MODEL )
        {
            if( CmdBuf[3] != 0x96 )                 // ʾоƬ 64KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA128_MODEL )
        {
            if( CmdBuf[3] != 0x97 )                 // ʾоƬ 128KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA8515_MODEL )
        {
            if( CmdBuf[3] != 0x93 )                 // ʾоƬ 8KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA8535_MODEL )
        {
            if( CmdBuf[3] != 0x93 )                 // ʾоƬ 8KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA48_MODEL )
        {
            if( CmdBuf[3] != 0x92 )                 // ʾоƬ 4KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA88_MODEL )
        {
            if( CmdBuf[3] != 0x93 )                 // ʾоƬ 8KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA168_MODEL )
        {
            if( CmdBuf[3] != 0x94 )                 // ʾоƬ 16KB Flash 洢
                return MCU_MODEL_ERR;
        }
        else
        {
            return MCU_MODEL_ERR;                   // ִ֧ͺŵMCU
        }

        P_NEXT:
        CmdBuf[0] = 0x30;                           //ͺŲѯ
        CmdBuf[1] = 0x00;
        CmdBuf[2] = 0x02;
        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
            return DATA_TRANS_ERR;
        //MHEX( CmdBuf, 4, "s2" );
        if( McuType == AUTO_MCU_MODEL )
        {
            if( ( CmdBuf[3] == 0x07 ) && ( tem8 == 0x93) )
                McuType = ATMEL_MEGA8_MODEL;
            else if( ( CmdBuf[3] == 0x03 ) && ( tem8 == 0x94 ) )
                McuType = ATMEL_MEGA16_MODEL;
            else if( ( CmdBuf[3] == 0x02 ) && ( tem8 == 0x95 ) )
                McuType = ATMEL_MEGA32_MODEL;
            else if( ( CmdBuf[3] == 0x02 ) && ( tem8 == 0x96 ) )
                McuType = ATMEL_MEGA64_MODEL;
            else if( ( CmdBuf[3] == 0x02 ) && ( tem8 == 0x97 ) )
                McuType = ATMEL_MEGA128_MODEL;
            else if( ( CmdBuf[3] == 0x06 ) && ( tem8 == 0x93 ) )
                McuType = ATMEL_MEGA8515_MODEL;
            else if( ( CmdBuf[3] == 0x08 ) && ( tem8 == 0x93 ) )
                McuType = ATMEL_MEGA8535_MODEL;
            else if( ( CmdBuf[3] == 0x05 ) && ( tem8 == 0x92 ) )
                McuType = ATMEL_MEGA48_MODEL;
            else if( ( CmdBuf[3] == 0x0a ) && ( tem8 == 0x93 ) )
                McuType = ATMEL_MEGA88_MODEL;
            else if( ( CmdBuf[3] == 0x06 ) && ( tem8 == 0x94 ) )
                McuType = ATMEL_MEGA168_MODEL;
            else
                return NO_SUPORT_ERR;
        }
        else if( McuType == ATMEL_MEGA8_MODEL )
        {
            if( CmdBuf[3] != 0x07 )                 // ͺΪMEGA8
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA16_MODEL )
        {
            if( CmdBuf[3] != 0x03 )                 // ͺΪMEGA16
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA32_MODEL )
        {
            if( CmdBuf[3] != 0x02 )                 // ͺΪMEGA32
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA64_MODEL )
        {
            if( CmdBuf[3] != 0x02 )                 // ͺΪMEGA64
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA128_MODEL )
        {
            if( CmdBuf[3] != 0x02 )                 // ͺΪMEGA128
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA8515_MODEL )
        {
            if( CmdBuf[3] != 0x06 )                 // ͺΪMEGA8515
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA8535_MODEL )
        {
            if( CmdBuf[3] != 0x08 )                 // ͺΪMEGA8535
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA48_MODEL )
        {
            if( CmdBuf[3] != 0x05 )                 // ͺΪMEGA48
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA88_MODEL )
        {
            if( CmdBuf[3] != 0x0a )                 // ͺΪMEGA48
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_MEGA168_MODEL )
        {
            if( CmdBuf[3] != 0x06 )                 // ͺΪMEGA168
                return MCU_MODEL_ERR;
        }
        else
        {
            return MCU_MODEL_ERR;                   // ִ֧ͺŵMCU
        }
    }
    else                                            // AT89Sϵ
    {
		if( SpiResetAT89s( Ch341index ) == FALSE )  // λAT89S
            return DATA_TRANS_ERR;
        Sleep( 1 );

        if( S51SpiEnable( Ch341index ) == FALSE )   // ģʽ
            return DATA_TRANS_ERR;
        Sleep( 100 );

        CmdBuf[0] =0XAC;
        CmdBuf[1] =0x53;
        CmdBuf[2] =0x00;                            // 89S51оƬɱ̲ѯ
        if( At89sISPoutin( Ch341index, 3, CmdBuf, 1, CmdBuf ) == FALSE )
            return DATA_TRANS_ERR;
        if( CmdBuf[0] != 0x69)
            return NO_MCU_ERR;

        Sleep( 20 );

        CmdBuf[0] =0X28;
        CmdBuf[1] =0x00;
        CmdBuf[2] =0x00;                            // AT89SϵMCU־λ
        if( At89sISPoutin( Ch341index, 3, CmdBuf, 1, CmdBuf ) == FALSE )
            return DATA_TRANS_ERR;
        if( CmdBuf[0] != 0x1E)
            return NO_MCU_ERR;
        // ־λ

        CmdBuf[0] =0X28;
        CmdBuf[1] =0x01;
        CmdBuf[2] =0x00;                            // AT89SϵMCU־λ
        if( At89sISPoutin( Ch341index, 3, CmdBuf, 1, CmdBuf ) == FALSE )
            return DATA_TRANS_ERR;

        if( McuType == ATMEL_AT89S51_MODEL )
        {
            if( CmdBuf[0] != 0x51 )
                return MCU_MODEL_ERR;
        }
        else if( McuType == ATMEL_AT89S52_MODEL )
        {
            if( CmdBuf[0] != 0x52 )
                return MCU_MODEL_ERR;
        }

        CmdBuf[0] =0X28;
        CmdBuf[1] =0x02;
        CmdBuf[2] =0x00;
        if( At89sISPoutin( Ch341index, 3, CmdBuf, 1, CmdBuf ) == FALSE )
            return DATA_TRANS_ERR;
        if( CmdBuf[0] != 0x06)
            return MCU_MODEL_ERR;
    }
    return NO_ERR;                              // ʼɹ
}

/*==============================================================================

: FindOneInNumber

: һ1ĸ

==============================================================================*/
UCHAR FindOneInNumber( ULONG Num )
{
UCHAR n;

    for( n=0; Num; n++ )
        Num &= Num-1;
    return n;
}

/*==============================================================================

: DownPrgToMcu

: ѳصMCU

==============================================================================*/
UCHAR WINAPI DownPrgToMcu( PVOID pBinBuf, ULONG FileLong )
{
UCHAR CmdBuf[CMD_BUF_LEN];  // 
UCHAR InBuf[BUF_LEN], OutBuf[BUF_LEN];
ULONG len;                  // ȡƫ

ULONG StopCount;            // 
ULONG cc;                  // 
ULONG BufLen;              // 

ULONG LineAdr;             // FLASHεַ
UCHAR ErrorCount;           // Уʧܴ
ULONG PageCount;

ULONG i, k, f;
ULONG index, offset;

// AT89S51
UCHAR FileDataBuf[ 258 ];       // ļݻ
UCHAR ReadDataBuf[ 256 ];       // ݻ

    len = FileLong;
    SendMessage( HwndProg, PBM_GETRANGE,        //ȡķΧ
        (WPARAM)TRUE,                           //TRUE ʾֵΪΧСֵ,FALSEʾֵ
        (LPARAM)&DownProgRange );

    if( (McuType >AUTO_MCU_MODEL ) && (McuType < ATMEL_AT89S51_MODEL) )
    {
        if( McuType == ATMEL_MEGA8_MODEL )
        {
            if( len > 8192 )               // ֻ֧8K
                return DATA_LEN_ERR;
            BufLen = 64;                        // MEGA8ÿҳΪ64ֽ
        }
        else if( McuType == ATMEL_MEGA16_MODEL )
        {
            if( len > 16384 )              // ֻ֧16K
                return DATA_LEN_ERR;
            BufLen = 128;                       // MEGA16ÿҳΪ128ֽ
        }
        else if( McuType == ATMEL_MEGA32_MODEL )
        {
            if( len > 32768 )              // ֻ֧32K
                return DATA_LEN_ERR;
            BufLen = 128;                       // MEGA32ÿҳΪ128ֽ
        }
        else if( McuType == ATMEL_MEGA64_MODEL )
        {
            if( len > 65536 )              // ֻ֧64K
                return DATA_LEN_ERR;
            BufLen = 256;                       // MEGA64ÿҳΪ256ֽ
        }
        else if( McuType == ATMEL_MEGA128_MODEL )
        {
            if( len > 131072 )             // ֻ֧128K
                return DATA_LEN_ERR;
            BufLen = 256;                       // MEGA128ÿҳΪ256ֽ
        }
        else if( McuType == ATMEL_MEGA8515_MODEL )
        {
            if( len > 8192 )               // ֻ֧8K
                return DATA_LEN_ERR;
            BufLen = 64;                        // MEGA16ÿҳΪ64ֽ
        }
        else if( McuType == ATMEL_MEGA8535_MODEL )
        {
            if( len > 8192 )               // ֻ֧8K
                return DATA_LEN_ERR;
            BufLen = 64;                        // MEGA16ÿҳΪ64ֽ
        }
        else if( McuType == ATMEL_MEGA48_MODEL )
        {
            if( len > 4096 )               // ֻ֧4K
                return DATA_LEN_ERR;
            BufLen = 64;                        // MEGA48ÿҳΪ64ֽ
        }
        else if( McuType == ATMEL_MEGA88_MODEL )
        {
            if( len > 8192 )               // ֻ֧4K
                return DATA_LEN_ERR;
            BufLen = 64;                        // MEGA88ÿҳΪ64ֽ
        }
        else if( McuType == ATMEL_MEGA168_MODEL )
        {
            if( len > 16384 )              // ֻ֧16K
                return DATA_LEN_ERR;
            BufLen = 128;                       // MEGA168ÿҳΪ128ֽ
        }
        else
        {
            //MessageBox( NULL, "", "ʾ", MB_OK );
            return NO_SUPORT_ERR;
        }

        #if 1
        CmdBuf[0] = 0xAC;                       // Chip Erase
        CmdBuf[1] = 0x80;
        CmdBuf[2] = 0xFF;
        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, FALSE ) == FALSE )
            return DATA_TRANS_ERR;
        #endif
        Sleep( 50 );                            // оƬ߳ٵȴ9ms

        if( len == 0 )
            return NO_ERR;                      // Ϊ0򷵻سɹ(ʾоƬ)

        PageCount = 0;
        offset = 0;
        cc = 0;
        ErrorCount = 0;
        StopCount = (len + 255) / 256;     // һ256ֽΪ׼
        while( 1 )
        {
            cc++;
            if( cc == (256 / BufLen) )
            {
                SendMessage( HwndProg, PBM_DELTAPOS,
                    (WPARAM)( MAX_PROG_LEN / StopCount), (LPARAM)0 );
                cc = 0;
            }

            if( len > BufLen )
                len -= BufLen;
            else
                len = 0;

            memcpy( OutBuf, &((PUCHAR)pBinBuf)[offset], BufLen );
            for( i=0; i!=BufLen; i++ )
            {
                 if( OutBuf[i] != 0xFF )
                     goto P_DOWN;
            }
            goto P_PASS;        // ȫΪ0XFFؽMCU

            P_DOWN:
            k = 0;
            f = i;                                              // ¼һ0XFFλ
            // жоƬ汾
            if( !CH341SPIBitSet )
            {
                for( i=0; i!=(BufLen / 2); i++ )                // ҳ
                {
                    CmdBuf[0] = 0x40;                           // ֵĵλֽ
                    CmdBuf[1] = 0x00;
                    CmdBuf[2] = (UCHAR)i;                       // ҳµĵַ
                    CmdBuf[3] = OutBuf[k++];                    // ص
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, CH341SPIBitSet ) == FALSE )
                        return DATA_TRANS_ERR;

                    CmdBuf[0] = 0x48;                           // ֵĸλֽ
                    CmdBuf[1] = 0x00;
                    CmdBuf[2] = (UCHAR)i;                       // ҳµĵַ
                    CmdBuf[3] = OutBuf[k++];                    // ص
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, CH341SPIBitSet ) == FALSE )
                        return DATA_TRANS_ERR;
                }
            }
            else
            {
                index = 0;
                for( i=0; i!=(BufLen / 2); i++ )                // ҳ
                {
                    CmdBuf[ index++ ] = 0x40;                   // ֵĵλֽ
                    CmdBuf[ index++ ] = 0x00;
                    CmdBuf[ index++ ] = (UCHAR)i;               // ҳµĵַ
                    CmdBuf[ index++ ] = OutBuf[k++];            // ص

                    CmdBuf[ index++ ] = 0x48;                   // ֵĸλֽ
                    CmdBuf[ index++ ] = 0x00;
                    CmdBuf[ index++ ] = (UCHAR)i;               // ҳµĵַ
                    CmdBuf[ index++ ] = OutBuf[k++];            // ص
                }
                if( MegaSpiOutInData( Ch341index, index, CmdBuf, CH341SPIBitSet ) == FALSE )
                    return DATA_TRANS_ERR;
            }

            i = FindOneInNumber( BufLen/2 - 1);
            CmdBuf[0] = 0x4C;                               // дռҳ
            CmdBuf[1] = (UCHAR)(PageCount>> (8 -i) );       // λֽ
            CmdBuf[2] = (UCHAR)(PageCount<< i );            // λֽ
            if( MegaSpiOutInData( Ch341index, 4, CmdBuf, CH341SPIBitSet ) == FALSE )
                return DATA_TRANS_ERR;                      // дҳ
            
            // ٵȴ4.5ms
            #if 1
            // ȡʱ ȡж 2008-7-22
            LineAdr = PageCount * BufLen / 2 + f/2;
            i = 0;
            while( 1 )
            {
                if( f % 2 == 0 )
                    CmdBuf[0] = 0x20;                      // ȡλֽ
                else
                    CmdBuf[0] = 0x28;

                CmdBuf[1] = (UCHAR)( LineAdr>>8 );         // BITַ
                CmdBuf[2] = (UCHAR)LineAdr;                // 8BITַ
                if( MegaSpiOutInData( Ch341index, 4, CmdBuf, CH341SPIBitSet ) == FALSE )
                    return DATA_TRANS_ERR;
                if( CmdBuf[3] != 0xff )
                    break;
                // ʧ ݴ
                if( i++ >= 100 )
                    return DATA_CMP_ERR;     
            }
            #endif

            P_PASS:
            PageCount++;                                    // һҳ
            offset += BufLen;
            if( len == 0 )
                break;
            if( StopBit )
                return REQ_STOP_ERR;
        }

        cc = 0;
        PageCount = 0; 
        offset = 0;
        len = FileLong;
        SetDlgItemText( MainDialog, IDC_STATIC_PROMPT, _T("ʼ...") );
        SendMessage( HwndProg, PBM_SETPOS, (WPARAM)DownProgRange.iLow, (LPARAM)0 );
        while( 1 )
        {
            cc++;
            if( cc == (256 / BufLen) )
            {
                SendMessage( HwndProg, PBM_DELTAPOS,
                    (WPARAM)( MAX_PROG_LEN / StopCount), (LPARAM)0 );
                cc = 0;
            }

            if( len > BufLen )
                len -= BufLen;
            else
                len = 0;

            k = 0;
            LineAdr = PageCount * BufLen / 2;                   // εַ
            if( !CH341SPIBitSet )
            {
                for( i=0; i!= (BufLen / 2); i++ )
                {
                    CmdBuf[0] = 0x20;                           // ȡλֽ
                    CmdBuf[1] = (UCHAR)( LineAdr>>8 );          // BITַ
                    CmdBuf[2] = (UCHAR)LineAdr;                 // 8BITַ
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, CH341SPIBitSet ) == FALSE )
                        return DATA_TRANS_ERR;
                    InBuf[k] = CmdBuf[3];
                    k++;

                    CmdBuf[0] = 0x28;                           // ȡλֽ
                    CmdBuf[1] = (UCHAR)( (LineAdr>>8) );        // BITַ
                    CmdBuf[2] = (UCHAR)LineAdr;                 // 8BITַ
                    if( MegaSpiOutInData( Ch341index, 4, CmdBuf, CH341SPIBitSet ) == FALSE )
                        return DATA_TRANS_ERR;
                    InBuf[k] = CmdBuf[3];
                    k++;
                    LineAdr++;
                }

                for( i=0; i!=BufLen; i++ )
                {
                    if( ((PUCHAR)pBinBuf)[offset + i] != InBuf[i] )
                        return DATA_CMP_ERR;
                }
            }
            else
            {
                index = 0;
                for( i=0; i!= (BufLen / 2); i++ )
                {
                    CmdBuf[index++] = 0x20;                     // ȡλֽ
                    CmdBuf[index++] = (UCHAR)( LineAdr>>8 );    // BITַ
                    CmdBuf[index++] = (UCHAR)LineAdr;           // 8BITַ
                    index++;

                    CmdBuf[index++] = 0x28;                     // ȡλֽ
                    CmdBuf[index++] = (UCHAR)( (LineAdr>>8) );  // BITַ
                    CmdBuf[index++] = (UCHAR)LineAdr;           // 8BITַ
                    index++;

                    LineAdr++;
                }
                if( MegaSpiOutInData( Ch341index, index, CmdBuf, CH341SPIBitSet ) == FALSE )
                    return DATA_TRANS_ERR;

                for( i=0; i!=BufLen; i++ )
                {
                    if( ((PUCHAR)pBinBuf)[offset + i] != CmdBuf[ i*4 + 3 ] )
                        return DATA_CMP_ERR;                // ݶԱȴ
                }
            }

            PageCount++;
            offset += BufLen;
            if( len == 0 )
                break;
            if( StopBit )
                return REQ_STOP_ERR;
        }
    }
    else
    {
        // ӶAT89S52жϺͽָʾ
        if( McuType == ATMEL_AT89S51_MODEL )
        {
            if( FileLong > 4096 )
                return DATA_LEN_ERR;
        }
        else if( McuType == ATMEL_AT89S52_MODEL )
        {
            if( FileLong > 8192 )
                return DATA_LEN_ERR;
        }

        CmdBuf[0] =0xac;                                    // оƬ
        CmdBuf[1] =0x80;
        if ( At89sISPoutput( Ch341index, 4, CmdBuf ) == FALSE )
        {
            return DATA_TRANS_ERR;
        }
        Sleep( 500 );                                       // ʱ500msȴִ

        if( FileLong == 0 )
            return NO_ERR;                                  // Ϊ0򷵻سɹ

        PageCount = 0;
        len = FileLong;
        offset = 0;
        cc = 0;
        StopCount = (FileLong + 255) / 256;                 // һ256ֽΪ׼
        while( 1 )
        {
            cc++;
            if( cc == 1  )
            {
                SendMessage( HwndProg, PBM_DELTAPOS,
                    (WPARAM)( MAX_PROG_LEN / StopCount), (LPARAM)0 );
                cc = 0;
            }
            if( len > 256 )
                len -= 256;
            else
                len = 0;

            memcpy( &FileDataBuf[2], &((PUCHAR)pBinBuf)[offset], 256 );

            FileDataBuf[0] = 0x50;                          // д89S51MCU
            FileDataBuf[1] = (UCHAR)PageCount;              // Page Modeڼҳ
            if ( At89sISPoutput( Ch341index, 256+2, FileDataBuf ) == FALSE )
                return DATA_TRANS_ERR;

            offset += 256;
            if( len == 0 )
                break;
            if( StopBit )
                return REQ_STOP_ERR;
            PageCount++;
        }

        PageCount = 0;
        len = FileLong;
        cc = 0;
        offset = 0;
        StopCount = (FileLong + 255) / 256;
        SetDlgItemText( MainDialog, IDC_STATIC_PROMPT, _T("ʼ...") );
        SendMessage( HwndProg, PBM_SETPOS, (WPARAM)DownProgRange.iLow, (LPARAM)0 );
        while( 1 )
        {
            cc++;
            if( cc == 1  )
            {
                SendMessage( HwndProg, PBM_DELTAPOS,
                    (WPARAM)( MAX_PROG_LEN / StopCount), (LPARAM)0 );
                cc = 0;
            }
            if( len > 256 )
                len -= 256;
            else
                len = 0;        

            FileDataBuf[0] = 0x30;                          // Read Program Memory page
            FileDataBuf[1] = (UCHAR)PageCount;
            if ( At89sISPoutin( Ch341index, 2, FileDataBuf, 256, ReadDataBuf ) == FALSE )                                          // ʧ
                return DATA_TRANS_ERR;

            for( i = 0; i != 255; i++ )                     // Уд
            {
                if( ((PUCHAR)pBinBuf)[ offset + i ] != ReadDataBuf[ i ] )
                    return DATA_CMP_ERR;
            }

            offset += 256;
            if( len == 0 )
                break;
            if( StopBit )
                return REQ_STOP_ERR;
            PageCount++;
        }
    }
    SendMessage( HwndProg, PBM_DELTAPOS, (WPARAM)(MAX_PROG_LEN - 1), (LPARAM)0 );
    return NO_ERR;                                          // 
}

/*==============================================================================

: DownDataToMcu

: صEEPROM(MEGA)

==============================================================================*/
UCHAR WINAPI DownDataToMcu( PVOID pDataBuf, ULONG FileLong )
{
USHORT i;
UCHAR tem8;
USHORT cc;                  // 
ULONG StopCount;
UCHAR CmdBuf[32];           // 

    SendMessage( HwndProg, PBM_GETRANGE,    // ȡķΧ
        (WPARAM)TRUE,                       // TRUE ʾֵΪΧСֵ,FALSEʾֵ
        (LPARAM)&DownProgRange );

    if( McuType == ATMEL_MEGA8_MODEL )
    {
        if( FileLong > 512 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA16_MODEL )
    {
        if( FileLong > 512 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA32_MODEL )
    {
        if( FileLong > 1024 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA64_MODEL )
    {
        if( FileLong > 2048 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA128_MODEL )
    {
        if( FileLong > 4096 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA8515_MODEL )
    {
        if( FileLong > 512 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA8535_MODEL )
    {
        if( FileLong > 512 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA48_MODEL )
    {
        if( FileLong > 256 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA88_MODEL )
    {
        if( FileLong > 512 )
            return DATA_LEN_ERR;
    }
    else if( McuType == ATMEL_MEGA168_MODEL )
    {
        if( FileLong > 512 )
            return DATA_LEN_ERR;
    }
    else
    {
        //MessageBox( NULL, "", "ʾ", MB_OK );
        return NO_SUPORT_ERR;
    }

    cc = 0;
    StopCount = ( FileLong + 15 ) / 16;       // 16ֽǰһ
    for( i=0; i!=FileLong; i++)
    {
        cc++;
        if( cc == 16 )
        {
            SendMessage( HwndProg, PBM_DELTAPOS,
                (WPARAM)(MAX_PROG_LEN / StopCount), (LPARAM)0 );
            cc = 0;
        }

        CmdBuf[0] = 0xC0;                   // ֵĵλֽ
        CmdBuf[1] = (UCHAR)(i>>8);
        CmdBuf[2] = (UCHAR)i;               // ҳµĵַ
        CmdBuf[3] = ((PUCHAR)pDataBuf)[i];  // ص
        tem8 = CmdBuf[3];
        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, CH341SPIBitSet ) == FALSE )
            return DATA_TRANS_ERR;
        Sleep( 20 );                        // ٵȴ9ms

        if( StopBit )
            return REQ_STOP_ERR;
    }
    
    cc = 0;
    SetDlgItemText( MainDialog, IDC_STATIC_PROMPT, _T("ʼ...") );
    SendMessage( HwndProg, PBM_SETPOS, (WPARAM)DownProgRange.iLow, (LPARAM)0 );
    for( i=0; i!=FileLong; i++)
    {
        cc++;
        if( cc == 16 )
        {
            SendMessage( HwndProg, PBM_DELTAPOS,
                (WPARAM)(MAX_PROG_LEN / StopCount), (LPARAM)0 );
            cc = 0;
        }

        CmdBuf[0] = 0xA0;                   // ֵĵλֽ
        CmdBuf[1] = (UCHAR)(i>>8);
        CmdBuf[2] = (UCHAR)i;               // ҳµĵַ
        CmdBuf[3] = ((PUCHAR)pDataBuf)[i];  // ص
        if( MegaSpiOutInData( Ch341index, 4, CmdBuf, CH341SPIBitSet ) == FALSE )
            return DATA_TRANS_ERR;
        if( ((PUCHAR)pDataBuf)[i] != CmdBuf[3] )
            return DATA_CMP_ERR;            // ݶԱȴ

        if( StopBit )
            return REQ_STOP_ERR;
    }
    SendMessage( HwndProg, PBM_DELTAPOS, (WPARAM)(MAX_PROG_LEN - 1), (LPARAM)0 );
    return NO_ERR;
}