#ifndef     _CH341IO_H
#define     _CH341IO_H

#define     BUF_LEN             256
#define     CMD_BUF_LEN         ((BUF_LEN / 2) * 8)
#define     MAX_BUF_LEN         ( 2 * mCH341_PACKET_LENGTH * CMD_BUF_LEN )

#define		SET_CH341_D1	0X02		// D1ߵƽ(at89s)

extern ULONG Ch341index;                // CH341
extern LONG McuType;                    // MCU
extern HWND HwndProg;                   // 
extern PBRANGE DownProgRange;           // Χ

#define     MAX_PROG_LEN        1024    // 

// 
#define     SET_SPI_RST         0X01    // λD1
#define     SET_SPI_CLK         0X08    // ʱD3
#define     SET_SPI_MOSI        0X20    // D5
#define     SET_SPI_MOSO        0X80    // D7

// ʼMCU̷
#define     NO_ERR              0X00    // ȷ
#define     DATA_TRANS_ERR      0X01    // ݴ
#define     NOT_PROG_ERR        0X02    // ɱ̴
#define     MCU_MODEL_ERR       0X03    // MCUͺѡ
#define     REQ_STOP_ERR        0X04    // ֹͣ
#define     NO_SUPORT_ERR       0X05    // ִ֧MCUͺ

// ݷ
#define     DATA_LEN_ERR        0X10    // ݳ
#define     DATA_CMP_ERR        0X11    // У
#define     NO_MEM_ERR          0X12    // ڴʧ
#define     NO_MCU_ERR          0X13    // ޷ʶMCU

// MCU
#define     MCU_COUNT               0X0D    // ܵMCU

// MCU
#define     AUTO_MCU_MODEL          0X00    // MCUͺԶʶ
#define     ATMEL_MEGA8_MODEL       0x01    // MEGA8
#define     ATMEL_MEGA16_MODEL      0x02    // MEGA16
#define     ATMEL_MEGA32_MODEL      0x03    // MEGA32
#define     ATMEL_MEGA64_MODEL      0x04    // MEGA64
#define     ATMEL_MEGA128_MODEL     0x05    // MEGA128
#define     ATMEL_MEGA8515_MODEL    0x06    // MEGA8515
#define     ATMEL_MEGA8535_MODEL    0x07    // MEGA8535
#define     ATMEL_MEGA48_MODEL      0x08    // MEGA48
#define     ATMEL_MEGA88_MODEL      0x09    // MEGA88
#define     ATMEL_MEGA168_MODEL     0X0A    // MEGA168
#define     ATMEL_AT89S51_MODEL     0X0B    // AT89S51
#define     ATMEL_AT89S52_MODEL     0X0C    // AT89S52

// ṩĺ
BOOL    WINAPI  SpiEnable(
    ULONG       index );                // ָCH341豸

BOOL    WINAPI  At89sISPoutput(
    ULONG       index,                  // ָCH341豸
    ULONG   OutLen,                     // ݳ
    LPCSTR  OutBuf );                   // ݻ

BOOL    WINAPI  At89sISPoutin(
    ULONG           index,              // ָCH341豸
    ULONG   OutLen,                     // ݳ
    LPCSTR  OutBuf,                     // ݻ
    ULONG   InLen,                      // ׼ȡݳ
    PUCHAR  InBuf );                    // ݻ

BOOL    WINAPI  MegaSpiOutInData(
    ULONG   index,                      // ָCH341豸
    ULONG   OutLen,                     // ݳ
    PVOID   DataBuf,                    // ݻSPIݷع
    BOOL    SpiBit );

UCHAR WINAPI IniMcuDown( void );        // ʼMCUع
UCHAR WINAPI DownPrgToMcu(
    PVOID pBinBuf,                      // BINļʼ
    ULONG FileLong );                   // BINļĳ

UCHAR WINAPI DownDataToMcu(
    PVOID pDataBuf,                     // MEGA(EEPROM)Ŀʼַ
    ULONG FileLong );                   // Ч
#endif