//#define     UNICODE             // ǷUNICOUDE

#ifdef      UNICODE
#define     _UNICODE
#endif

#include    <stdio.h>
#include    <tchar.h>
#include    <windows.h>
#include    <WINERROR.H>
#include	<locale.h>
#include    "MSHOW.H"


/*==============================================================================

: ShowProgBulid

: ʾʱ

==============================================================================*/
void ShowProgBulid( void )
{
TCHAR DateStr[] = _T(__DATE__);
TCHAR TimeStr[] = _T(__TIME__);

    PSTR( DateStr, 0 );
    PSTR( " ", 0 );
    PSTR( TimeStr, 1 );
}

/*==============================================================================

: GetLastResult

: ѴϢָָĻ,ش

==============================================================================*/
ULONG GetLastResult( void *p )
{
ULONG LastResult;
TCHAR szSysMsg[128];

    LastResult = GetLastError();
    FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, 0, LastResult,
        MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT ), szSysMsg, sizeof(szSysMsg), 0);

    __try
    {
        _stprintf( p, _T("Error code = 0x%08x: %s"), LastResult, szSysMsg );
    }
    __except( EXCEPTION_EXECUTE_HANDLER )
    {
        return 0xFFFFFFFF;
    }
    return LastResult;
}

/*==============================================================================

: ShowLastResult

: ʾϴд

==============================================================================*/
void ShowLastResult( void )
{
ULONG LastResult = 0;
TCHAR szSysMsg[128], tem[128];

    LastResult = GetLastError();
    FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, 0, LastResult,
        MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT ), szSysMsg, sizeof(szSysMsg), 0);

    _stprintf( tem, _T("Err code = 0x%08x: %s"), LastResult, szSysMsg );
    MessageBox( NULL, tem, _T( MSHOW_TITLE ), MB_OK );
}

/*==============================================================================

: PrintStrA

: ڿ̨дӡANSIַ,enΪ0

==============================================================================*/
void PrintStrA( PVOID p, BOOL en )
{
	__try                                           // ֹ쳣(һ쳣)
	{
		_tprintf( p );
	}

	__except( EXCEPTION_EXECUTE_HANDLER )           // 쳣
	{
		UINT code = GetExceptionCode( );
		_tprintf( _T("\nException Code = 0X%08X\n"), code );
		return;
	}

    if( en )                                            // س
    {
		_tprintf( _T("\n") );
    }
}

/*==============================================================================

: PrintArray

: ڿ̨дӡڴռ

(*pΪʼַ,lengthΪ͵ֽ,enΪ0)

==============================================================================*/
void PrintArray( PVOID p, ULONG length, BOOL en )
{
PUCHAR temp;

    temp = p;
    while( length )
    {
        __try
        {
            printf( "%02X", *temp );
        }

        __except( EXCEPTION_EXECUTE_HANDLER )
        {
            UINT code = GetExceptionCode( );
            printf( "\nException Code = 0X%08X\n", code );
            return;
        }
        putchar( 32 );                                  // ո
        temp++;
        --length;
    }

    if( en )
    {
        putchar( 13 );
        putchar( 10 );
    }
}

/*==============================================================================

: PrintStrToFile

: ӡַ(ANSI)ļ

*pΪڴ濪ʼַ,enΪǷڴַĩβ,*FileNameΪݴļ

==============================================================================*/
void PrintStrToFile( PVOID p, BOOL en, LPCSTR FileName )
{
HANDLE FileHandle;
ULONG WriteCout;
UCHAR enbuf[ ] ={13,10};        // س
UCHAR exbuf[30];                // 쳣ַŻ

    FileHandle = CreateFileA( FileName, GENERIC_WRITE, FILE_SHARE_DELETE, NULL,
            OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0 );
    if( FileHandle == INVALID_HANDLE_VALUE )        // ļʧ
    {
        ShowLastResult( );
        return;
    }
    SetFilePointer( FileHandle, 0, 0, FILE_END );   // ƶļָ뵽ļĩβ
    __try                                           // ֹڴ淢쳣
    {
        WriteFile( FileHandle, (LPCVOID)p, strlen( ( LPCSTR )p ), (LPDWORD)&WriteCout, NULL );
        if( WriteCout != strlen( ( LPCSTR )p ) )
        {
            ShowLastResult();                       // дļ
            return;
        }
    }

    __except( EXCEPTION_EXECUTE_HANDLER )
    {
        UINT code = GetExceptionCode( );
        sprintf( exbuf, "Exception Code = 0X%08X", code );
        WriteFile( FileHandle, (LPCVOID)exbuf,
            strlen( exbuf ), (LPDWORD)&WriteCout, NULL );
        WriteFile( FileHandle, (LPCVOID)enbuf, 2,
            (LPDWORD)&WriteCout, NULL );
        return;
    }

    if( en )
    {                                               // ַĩβӻس
        WriteFile( FileHandle, (LPCVOID)enbuf, 2, (LPDWORD)&WriteCout, NULL );
    }
    CloseHandle( FileHandle );                      // رļ
}

/*==============================================================================

: PrintArrayToFile

: ӡڴռݵļ

*pΪڴ濪ʼַ,lengthΪӡ,enΪǷڴַĩβ,*FileNameΪݴļ

==============================================================================*/
void PrintArryToFile( PVOID p, ULONG length, BOOL en, LPCSTR FileName )
{
HANDLE FileHandle;
USHORT i;
ULONG WriteCout, temp32;
PVOID p1, p2;
UCHAR enbuf[ ] ={13,10};                            // سŻ
UCHAR exbuf[30];                                    // 쳣ַŻ

    FileHandle = CreateFileA( FileName, GENERIC_WRITE, FILE_SHARE_DELETE, NULL,
        OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0 );
    SetFilePointer( FileHandle, 0, 0, FILE_END );   // ƶļָ뵽ļĩβ

    temp32 = length*2 + length +2;                  // ӿոͻس
    p1 = malloc( temp32 );
    if( p1 == NULL)                                 // ڴʧ
        return;

    p2 = p1;                                        // ڴ俪ʼַ
    for( i = 0; i != length; i++ )
    {
        __try                                               // ֹڴ淢쳣
        {
            sprintf( (PUCHAR)p2, "%02X ", *(PUCHAR)p );   // ʵַת
        }

        __except( EXCEPTION_EXECUTE_HANDLER )
        {
            UINT code = GetExceptionCode( );
            sprintf( exbuf, "Exception Code = 0X%08X", code );
            WriteFile( FileHandle, (LPCVOID)exbuf,
                strlen( exbuf ), (LPDWORD)&WriteCout, NULL );
            WriteFile( FileHandle, (LPCVOID)enbuf, 2,
                (LPDWORD)&WriteCout, NULL );
            return;
        }

        ( (PUCHAR)p )++;
        ( (PUCHAR)p2 ) += 3;
    }

    WriteFile( FileHandle, (LPCVOID)p1, (temp32 -2), (LPDWORD)&WriteCout, NULL );
    if( WriteCout != (temp32 -2) )
    {
            ShowLastResult();                       // дļ
    }

    if( en )
    {                                               // ַĩβӻس
        WriteFile( FileHandle, (LPCVOID)enbuf, 2, (LPDWORD)&WriteCout, NULL );
    }
    CloseHandle( FileHandle );
    free( p1 );
}

/*==============================================================================

: MessageStrA

: ʾַʾԻ

==============================================================================*/
void MessageStr(void *p )
{
   MessageBox( NULL, (TCHAR *)p, _T(MSHOW_TITLE), MB_OK);
}

/*==============================================================================

: MessageArry

: Իʾڴ(*pΪʼַ,lengthΪ͵ֽ,lpCaptionΪʾ)

==============================================================================*/
void MessageArry( PVOID p, ULONG length,  LPCSTR lpCaption )
{
PVOID tp1;  //ʱָ
PVOID tp2;
ULONG i;

    tp1 = malloc( length * 2 + length + 1); // ANSI,һֽתΪ2ַӿոӽ
    if( tp1 == NULL )
        return;

    tp2 = tp1;
    for( i = 0; i !=length; i++ )
    {
        __try
        {
            sprintf( tp2, "%02X ", *( PUCHAR )p );
        }

        __except( EXCEPTION_EXECUTE_HANDLER )
        {
            UINT code = GetExceptionCode( );
            printf( "\nException Code = 0X%08X\n", code );
            return;
        }
        ( (PUCHAR)p )++;
        (PUCHAR)tp2 += 3;                  // ַһո
    }
    *( (PUCHAR)tp2 ) = 0;
    MessageBoxA( NULL, (LPCSTR)tp1, lpCaption, MB_OK );
    free( tp1 );                            // ͷڴ
}

/*==============================================================================

: SendStrToNotepad

: ַ±(*pΪʼַ,enΪ0)

==============================================================================*/
void SendStrToNotepad( PVOID p, BOOL en )
{
HWND oldhwnd = NULL;
HWND Notehwnd;
POINT Point;
UCHAR exbuf[30];        // 쳣ַŻ
BOOL ExSign;

    ExSign = FALSE;     // ûз쳣
    Point.x = 20;
    Point.y = 20;
    Notehwnd = FindWindowA( SEND_CLASS_NAME, NULL );
    if( Notehwnd)
    {
        oldhwnd = ChildWindowFromPoint( Notehwnd, Point );
        if( !oldhwnd )
        {
            SERR();                         //ʾϢ
            return;
        }

        while( 1 )
        {
            __try
            {
                if( *(PUCHAR)p == 0 )
                    break;
                PostMessage( oldhwnd, WM_CHAR, (UINT)(*( UCHAR *)p ), 1 );
            }

            __except( EXCEPTION_EXECUTE_HANDLER )
            {
                UINT code = GetExceptionCode( );
                sprintf( exbuf, "Exception Code = 0X%08X", code );
                p = exbuf;
                continue;
            }
            ( (PUCHAR)p )++;
        }

        if( en )
        {
            PostMessage( oldhwnd, WM_CHAR, (UINT)'\n', 1 );         // س
        }
    }
    else
    {
        MessageBoxA( NULL," 򿪼±", MSHOW_TITLE, MB_OK );
    }
}

/*==============================================================================

: SendArryToNotepad

: ʮ±(*pΪʼַ,lengthΪ͵ֽ,enΪ0)

ҪעⷢƵʲܹ!!!,ڷʱܶԼ±в

==============================================================================*/
void SendArryToNotepad( PVOID p, ULONG length, BOOL en )
{
HWND oldhwnd = NULL;
HWND Notehwnd;
POINT Point;
UCHAR Buf[3];
UCHAR exbuf[30];        // 쳣ַŻ
BOOL ExSign;

    ExSign = FALSE;     // ûз쳣
    Point.x = 20;
    Point.y = 20;
    Notehwnd = FindWindowA( SEND_CLASS_NAME, NULL );
    if( Notehwnd)
    {
        oldhwnd = ChildWindowFromPoint( Notehwnd, Point );
        if( !oldhwnd )
        {
            SERR();                         //ʾϢ
            return;
        }

        while( length )
        {
            __try
            {
                sprintf( Buf, "%02X ", *(UCHAR *)p );
            }
            __except( EXCEPTION_EXECUTE_HANDLER )
            {
                UINT code = GetExceptionCode( );
                sprintf( exbuf, "Exception Code = 0X%08X", code );
                p = exbuf;
                ExSign = TRUE;
                length = ( strlen( p ) + 1) / 2;                    // õӡ쳣ַ
            }
            if( ExSign )
            {
                Buf[0] = *((UCHAR *)p)++;
                Buf[1] = *( UCHAR *)p;
            }
            PostMessage( oldhwnd, WM_CHAR, (UINT)Buf[0], 1 );
            PostMessage( oldhwnd, WM_CHAR, (UINT)Buf[1], 1 );
            if( !ExSign )
            {
                PostMessage( oldhwnd, WM_CHAR, (UINT)0x20, 1 );     // ո
            }
            ( (UCHAR *)p )++;
            length--;
        }
        if( en )
        {
            PostMessage( oldhwnd, WM_CHAR, (UINT)'\n', 1 );         // س
        }
    }
    else
    {
        MessageBoxA( NULL," 򿪼±", MSHOW_TITLE, MB_OK );
    }
}