/*****************************************************************************
**                      Copyright  (C)  WCH  2001-2022                      **
**                      Web:  http://wch.cn                                 **
******************************************************************************
Abstract:
    USB2.0תоƬCH347,480MbpsUSBչUARTSPII2CJTAG
Environment:
user mode only,VC6.0 and later
Notes:
Copyright (c) 2022 Nanjing Qinheng Microelectronics Co., Ltd.
--*/

#ifndef		_CH347_DLL_H
#define		_CH347_DLL_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WIN64
#define		mOFFSET( s, m )			( (ULONG_PTR) & ( ( ( s * ) 0 ) -> m ) )	// ȡṹԱƫƵַĺ
#else
#define		mOFFSET( s, m )			( (ULONG) & ( ( ( s * ) 0 ) -> m ) )	// ȡṹԱƫƵַĺ
#endif

#ifndef		max
#define		max( a, b )				( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )	// ϴֵ
#endif

#ifndef		min
#define		min( a, b )				( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )	// Сֵ
#endif

#ifdef		ExAllocatePool
#undef		ExAllocatePool						// ɾTAGڴ
#endif

#ifndef		NTSTATUS
typedef		LONG	NTSTATUS;					// ״̬
#endif

//CH31DLLCH341WDM
#ifndef _CH341_DLL_H
typedef	struct	_USB_SETUP_PKT {				// USBƴĽ׶εṹ
	UCHAR			mUspReqType;				// 00H 
	UCHAR			mUspRequest;				// 01H 
	union	{
		struct	{
			UCHAR	mUspValueLow;				// 02H ֵֽ
			UCHAR	mUspValueHigh;				// 03H ֵֽ
		};
		USHORT		mUspValue;					// 02H-03H ֵ
	};
	union	{
		struct	{
			UCHAR	mUspIndexLow;				// 04H ֽ
			UCHAR	mUspIndexHigh;				// 05H ֽ
		};
		USHORT		mUspIndex;					// 04H-05H 
	};
	USHORT			mLength;					// 06H-07H ݽ׶εݳ
} mUSB_SETUP_PKT, *mPUSB_SETUP_PKT;


typedef	struct	_WIN32_COMMAND {				// WIN32ӿڽṹ
	union	{
		ULONG		mFunction;					// ʱָܴ߹ܵ
		NTSTATUS	mStatus;					// ʱز״̬
	};
	ULONG			mLength;					// ȡ,غݵĳ
	union	{
		mUSB_SETUP_PKT	mSetupPkt;				// USBƴĽ׶ε
		UCHAR			mBuffer[ 512];      	// ݻ,Ϊ0255B
	};
} mWIN32_COMMAND, *mPWIN32_COMMAND;
// WIN32Ӧòӿ
#define		IOCTL_CH341_COMMAND		( FILE_DEVICE_UNKNOWN << 16 | FILE_ANY_ACCESS << 14 | 0x0f34 << 2 | METHOD_BUFFERED )	// רýӿ

#define		mWIN32_COMMAND_HEAD		mOFFSET( mWIN32_COMMAND, mBuffer )	// WIN32ӿڵͷ

#define		mCH341_MAX_NUMBER		16			// ͬʱӵCH341

#define		mMAX_BUFFER_LENGTH		0x1000		// ݻ󳤶4096

#define		mMAX_COMMAND_LENGTH		( mWIN32_COMMAND_HEAD + mMAX_BUFFER_LENGTH )	// ݳȼṹͷĳ

#define		mDEFAULT_BUFFER_LEN		0x0400		// ݻĬϳ1024

#define		mDEFAULT_COMMAND_LEN	( mWIN32_COMMAND_HEAD + mDEFAULT_BUFFER_LEN )	// Ĭݳȼṹͷĳ

// CH341˵ַ
#define		mCH347_ENDP_DATA_UP		0x86		// CH347ݿϴ˵ĵַ
#define		mCH347_ENDP_DATA_DOWN	0x06		// CH347ݿ´˵ĵַ

// 豸ӿṩĹܵ
#define		mPipeDeviceCtrl			0x00000004	// CH347ۺϿƹܵ
#define		mPipeDataUp				0x00000006	// CH347ݿϴܵ
#define		mPipeDataDown			0x00000007	// CH347ݿ´ܵ

// ӦòӿڵĹܴ
#define		mFuncNoOperation		0x00000000	// ޲
#define		mFuncGetVersion			0x00000001	// ȡ汾
#define		mFuncGetConfig			0x00000002	// ȡUSB豸
#define		mFuncSetTimeout			0x00000009	// USBͨѶʱ
#define		mFuncSetExclusive		0x0000000b	// öռʹ
#define		mFuncResetDevice		0x0000000c	// λUSB豸
#define		mFuncResetPipe			0x0000000d	// λUSBܵ
#define		mFuncAbortPipe			0x0000000e	// ȡUSBܵ
#define		mFuncBufferMode			0x00000020	// 趨ϴģʽѯеݳ
#define		mFuncBufferModeDn		0x00000021	// 趨´ģʽѯеݳ
#define		mFuncGetVersionEx		0x00000022	// ȡ汾żоƬͺ
// USB豸׼
#define		mUSB_CLR_FEATURE		0x01
#define		mUSB_SET_FEATURE		0x03
#define		mUSB_GET_STATUS			0x00
#define		mUSB_SET_ADDRESS		0x05
#define		mUSB_GET_DESCR			0x06
#define		mUSB_SET_DESCR			0x07
#define		mUSB_GET_CONFIG			0x08
#define		mUSB_SET_CONFIG			0x09
#define		mUSB_GET_INTERF			0x0a
#define		mUSB_SET_INTERF			0x0b
#define		mUSB_SYNC_FRAME			0x0c

// CH341ƴĳר
#define		mCH341_VENDOR_READ		0xC0		// ͨƴʵֵCH341רö
#define		mCH341_VENDOR_WRITE		0x40		// ͨƴʵֵCH341רд

#define		mCH341A_CMD_I2C_STREAM	0xAA		// I2Cӿڵ,ӴֽڿʼΪI2C
#define		mCH341A_CMD_UIO_STREAM	0xAB		// UIOӿڵ,ӴֽڿʼΪ
#define		mCH341A_CMD_PIO_STREAM	0xAE		// PIOӿڵ,ӴֽڿʼΪ
// CH341Aƴĳר
#define		mCH341A_BUF_CLEAR		0xB2		// δɵ
#define		mCH341A_I2C_CMD_X		0x54		// I2Cӿڵ,ִ
#define		mCH341A_DELAY_MS		0x5E		// Ϊλʱָʱ
#define		mCH341A_GET_VER			0x5F		// ȡоƬ汾

#define		mCH341A_CMD_I2C_STM_STA	0x74		// I2Cӿڵ:ʼλ
#define		mCH341A_CMD_I2C_STM_STO	0x75		// I2Cӿڵ:ֹͣλ
#define		mCH341A_CMD_I2C_STM_OUT	0x80		// I2Cӿڵ:,λ5-λ0Ϊ,ֽΪ,0ֻһֽڲӦ
#define		mCH341A_CMD_I2C_STM_IN	0xC0		// I2Cӿڵ:,λ5-λ0Ϊ,0ֻһֽڲӦ
#define		mCH341A_CMD_I2C_STM_MAX	( min( 0x3F, mCH341_PACKET_LENGTH ) )	// I2Cӿڵݵ󳤶
#define		mCH341A_CMD_I2C_STM_SET	0x60		// I2Cӿڵ:ò,λ2=SPII/O(0=뵥,1=˫˫),λ1λ0=I2Cٶ(00=,01=׼,10=,11=)
#define		mCH341A_CMD_I2C_STM_US	0x40		// I2Cӿڵ:΢Ϊλʱ,λ3-λ0Ϊʱֵ
#define		mCH341A_CMD_I2C_STM_MS	0x50		// I2Cӿڵ:Ϊλʱ,λ3-λ0Ϊʱֵ
#define		mCH341A_CMD_I2C_STM_DLY	0x0F		// I2Cӿڵʱֵ
#define		mCH341A_CMD_I2C_STM_END	0x00		// I2Cӿڵ:ǰ

#define		mCH341A_CMD_UIO_STM_IN	0x00		// UIOӿڵ:D7-D0
#define		mCH341A_CMD_UIO_STM_DIR	0x40		// UIOӿڵ:趨I/OD5-D0,λ5-λ0Ϊ
#define		mCH341A_CMD_UIO_STM_OUT	0x80		// UIOӿڵ:D5-D0,λ5-λ0Ϊ
#define		mCH341A_CMD_UIO_STM_US	0xC0		// UIOӿڵ:΢Ϊλʱ,λ5-λ0Ϊʱֵ
#define		mCH341A_CMD_UIO_STM_END	0x20		// UIOӿڵ:ǰ

#define		MAX_DEVICE_PATH_SIZE	128			// 豸Ƶַ
#define		MAX_DEVICE_ID_SIZE		64			// 豸IDַ
#endif _CH341_DLL_H

//ӿ
#define CH347_USB_VENDOR   0
#define CH347_USB_HID      2
#define CH347_USB_VCP      3

//CH347_USB_VENDOR֧CH341/7
#define CHIP_TYPE_CH341    0
#define CHIP_TYPE_CH347    1

//оƬܽӿں
#define CH347_FUNC_UART      0
#define CH347_FUNC_SPI_IIC   1
#define CH347_FUNC_JTAG_IIC  2

#define DEFAULT_READ_TIMEOUT  500  //Ĭ϶ʱ
#define DEFAULT_WRITE_TIMEOUT 500  //Ĭдʱ

#define		mCH347_PACKET_LENGTH	512		// CH347ֵ֧ݰĳ

#pragma pack(1) 
//SPI
typedef struct _SPI_CONFIG{
	UCHAR           iMode;                 // 0-3:SPI Mode0/1/2/3
	UCHAR           iClock;                // 0=60MHz, 1=30MHz, 2=15MHz, 3=7.5MHz, 4=3.75MHz, 5=1.875MHz, 6=937.5KHz7=468.75KHz
	UCHAR			iByteOrder;            // 0=λǰ(LSB), 1=λǰ(MSB)
	USHORT          iSpiWriteReadInterval; // SPIӿڳȡдλΪuS
	UCHAR           iSpiOutDefaultData;    // SPIʱĬ
	ULONG			iChipSelect;           // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01ֱѡCS1/CS2Ϊ͵ƽЧƬѡ
	UCHAR           CS1Polarity;           // λ0ƬѡCS1Կƣ0͵ƽЧ1ߵƽЧ
	UCHAR           CS2Polarity;           // λ0ƬѡCS2Կƣ0͵ƽЧ1ߵƽЧ
	USHORT          iIsAutoDeativeCS;      // ɺǷԶƬѡ
	USHORT          iActiveDelay;          // Ƭѡִждʱʱ,λus
	ULONG           iDelayDeactive;        // Ƭѡִждʱʱ,λus
}mSpiCfgS,*mPSpiCfgS;

//豸Ϣ
typedef struct _DEV_INFOR{
	UCHAR    iIndex;                 // ǰ
	UCHAR    DevicePath[MAX_PATH];   // 豸,CreateFile
	UCHAR    UsbClass;               // 0:CH347_USB_CH341, 2:CH347_USB_HID,3:CH347_USB_VCP
	UCHAR    FuncType;               // 0:CH347_FUNC_UART,1:CH347_FUNC_SPI_I2C,2:CH347_FUNC_JTAG_I2C
	CHAR     DeviceID[64];           // USB\VID_xxxx&PID_xxxx
	UCHAR    ChipMode;               // оƬģʽ,0:Mode0(UART0/1); 1:Mode1(Uart1+SPI+I2C); 2:Mode2(HID Uart1+SPI+I2C) 3:Mode3(Uart1+Jtag+IIC)
	HANDLE   DevHandle;              // 豸
	USHORT   BulkOutEndpMaxSize;     // ϴ˵С
	USHORT   BulkInEndpMaxSize;      // ´˵С
	UCHAR    UsbSpeedType;           // USBٶͣ0:FS,1:HS,2:SS
	UCHAR    CH347IfNum;             // 豸ӿں: 0:UART,1:SPI/IIC/JTAG/GPIO
	UCHAR    DataUpEndp;             // ˵ַ
	UCHAR    DataDnEndp;             // ˵ַ
	CHAR     ProductString[64];      // USBƷַ
	CHAR     ManufacturerString[64]; // USBַ
	ULONG    WriteTimeout;           // USBдʱ
	ULONG    ReadTimeout;            // USBʱ
	CHAR     FuncDescStr[64];        // ӿڹ
	UCHAR    FirewareVer;            // ̼汾
}mDeviceInforS,*mPDeviceInforS;
#pragma pack() 

// CH347ģʽú,֧CH347ģʽµĴ򿪡رաUSBUSBдHID
//USB豸
HANDLE WINAPI CH347OpenDevice(ULONG DevI);

//رUSB豸
BOOL WINAPI CH347CloseDevice(ULONG iIndex);

//ȡ豸Ϣ
BOOL WINAPI CH347GetDeviceInfor(ULONG iIndex,mDeviceInforS *DevInformation);

// 汾汾豸汾оƬ(CH341(FS)/CH347HS)
BOOL	WINAPI	CH347GetVersion(ULONG 			 iIndex, 
							    PUCHAR           iDriverVer,
								PUCHAR           iDLLVer,
							    PUCHAR           ibcdDevice,
							    PUCHAR           iChipType);  //CHIP_TYPE_CH341/7

typedef		VOID	( CALLBACK	* mPCH347_NOTIFY_ROUTINE ) (								 // 豸¼֪ͨص
															ULONG			iEventStatus );  // 豸¼͵ǰ״̬(ж): 0=豸γ¼, 3=豸¼

#define		CH347_DEVICE_ARRIVAL		3		// 豸¼,Ѿ
#define		CH347_DEVICE_REMOVE_PEND	1		// 豸Ҫγ
#define		CH347_DEVICE_REMOVE			0		// 豸γ¼,Ѿγ

BOOL	WINAPI	CH347SetDeviceNotify(											// 趨豸¼֪ͨ
									 ULONG					iIndex,				// ָ豸,0Ӧһ豸
									 PCHAR					iDeviceID,			// ѡ,ַָ,ָص豸ID,ַ\0ֹ
									 mPCH347_NOTIFY_ROUTINE	iNotifyRoutine );   // ָ豸¼ص,ΪNULLȡ¼֪ͨ,ڼ⵽¼ʱøó

// ȡUSBݿ
BOOL	WINAPI	CH347ReadData( ULONG			iIndex,          // ָ豸
							   PVOID			oBuffer,         // ָһ㹻Ļ,ڱȡ
							   PULONG			ioLength );		 // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

// дȡUSBݿ
BOOL	WINAPI	CH347WriteData(ULONG			iIndex,      // ָ豸
							   PVOID			iBuffer,     // ָһ,׼д
							   PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

// USBݶдĳʱ
BOOL	WINAPI	CH347SetTimeout(ULONG			iIndex,         // ָ豸
							    ULONG			iWriteTimeout,  // ָUSBдݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
								ULONG			iReadTimeout ); // ָUSBȡݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)

/***************SPI********************/
// SPIʼ
BOOL	WINAPI	CH347SPI_Init(ULONG iIndex,mSpiCfgS *SpiCfg);

//ȡSPIϢ
BOOL    WINAPI  CH347SPI_GetCfg(ULONG iIndex,mSpiCfgS *SpiCfg);

//Ƭѡ״̬,ʹǰȵCH347SPI_InitCS
BOOL	WINAPI	CH347SPI_ChangeCS(ULONG			iIndex,         // ָ豸	
								  UCHAR         iStatus);       // 0=Ƭѡ,1=Ƭѡ

//SPIƬѡ
BOOL	WINAPI	CH347SPI_SetChipSelect(ULONG			iIndex,            // ָ豸
									   USHORT           iEnableSelect,     // ͰλΪCS1߰λΪCS2; ֵֽΪ1=CS,Ϊ0=ԴCS
									   USHORT           iChipSelect,       // ͰλΪCS1߰λΪCS2;Ƭѡ,0=Ƭѡ,1=Ƭѡ
									   ULONG            iIsAutoDeativeCS,  // 16λΪCS116λΪCS2;ɺǷԶƬѡ
									   ULONG            iActiveDelay,      // 16λΪCS116λΪCS2;Ƭѡִждʱʱ,λus
									   ULONG            iDelayDeactive);   // 16λΪCS116λΪCS2;Ƭѡִждʱʱ,λus

//SPI4д
BOOL	WINAPI	CH347SPI_Write(ULONG			iIndex,          // ָ豸	
							   ULONG			iChipSelect,     // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ƭѡ
							   ULONG			iLength,         // ׼ֽ	
							   ULONG			iWriteStep,      // ׼ȡĵĳ
							   PVOID			ioBuffer);       // ָһ,׼MOSIд

//SPI4.дݣЧʽCH347SPI_WriteReadߺܶ
BOOL	WINAPI	CH347SPI_Read(ULONG			iIndex,           // ָ豸	
							  ULONG			iChipSelect,      // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ƭѡ
							  ULONG         oLength,          // ׼ֽ
							  PULONG		iLength,          // ׼ֽ	
							  PVOID			ioBuffer);        // ָһ,׼DOUTд,غǴDIN

// SPI,4߽ӿ
BOOL	WINAPI	CH347SPI_WriteRead(ULONG			iIndex,       // ָ豸
								   ULONG			iChipSelect,  // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ƭѡ
								   ULONG			iLength,      // ׼ֽ
								   PVOID			ioBuffer );   // ָһ,׼DOUTд,غǴDIN

// SPI,4߽ӿ
BOOL	WINAPI	CH347StreamSPI4(ULONG			iIndex,       // ָ豸
								ULONG			iChipSelect,  // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч
								ULONG			iLength,      // ׼ֽ
								PVOID			ioBuffer );   // ָһ,׼DOUTд,غǴDIN

/***************JTAG********************/
//JTAGӿڳʼģʽٶ
BOOL	WINAPI	CH347Jtag_INIT(ULONG iIndex,
							   UCHAR iClockRate);   //ͨٶȣЧֵΪ0-5ֵԽͨٶԽ

//ȡJtagٶ
BOOL    WINAPI  CH347Jtag_GetCfg(ULONG iIndex,         // ָ豸
							     UCHAR *ClockRate);    //ͨٶȣЧֵΪ0-5ֵԽͨٶԽ

//λʽJTAG IR/DRݶд.ݵĶдָ״̬лȿഫ䡣ݴ䣬ʹCH347Jtag_WriteRead_Fast
//4096ֽΪλд
//״̬:Run-Test->Shift-IR/DR..->Exit IR/DR -> Run-Test
BOOL	WINAPI	CH347Jtag_WriteRead(ULONG			iIndex,           // ָ豸
									BOOL            IsDR,             // =TRUE: DRݶд,=FALSE:IRݶд
									ULONG			iWriteBitLength,  // д,׼дĳ
									PVOID			iWriteBitBuffer,  // ָһ,׼д	
									PULONG			oReadBitLength,   // ָ򳤶ȵԪ,غΪʵʶȡĳ
									PVOID			oReadBitBuffer ); // ָһ㹻Ļ,ڱȡ

//JTAG IR/DRд,ڶֽдJTAG̼زӲ4KдȲ4096ֽڡСе
//״̬:Run-Test->Shift-IR/DR..->Exit IR/DR -> Run-Test
BOOL	WINAPI	CH347Jtag_WriteRead_Fast(ULONG		iIndex,            // ָ豸
										 BOOL       IsDR,              // =TRUE: DRݶд,=FALSE:IRݶд
										 ULONG		iWriteBitLength,   // д,׼дĳ
										 PVOID		iWriteBitBuffer,   // ָһ,׼д	
										 PULONG		oReadBitLength,    // ָ򳤶ȵԪ,غΪʵʶȡĳ
										 PVOID		oReadBitBuffer );  // ָһ㹻Ļ,ڱȡ

//лJTAG״̬
BOOL WINAPI CH347Jtag_SwitchTapState(UCHAR TapState);

//JTAG DRд,ֽΪλ,ڶֽдJTAG̼ز
//״̬:Run-Test->Shift-DR..->Exit DR -> Run-Test
BOOL	WINAPI	CH347Jtag_ByteWriteDR(ULONG			iIndex,        // ָ豸									
									  ULONG			iWriteLength,  // д,׼дֽڳ
									  PVOID			iWriteBuffer); // ָһ,׼д	

//JTAG DR,ֽΪλ,ֽ
//״̬:Run-Test->Shift-DR..->Exit DR -> Run-Test
BOOL	WINAPI	CH347Jtag_ByteReadDR(ULONG			iIndex,        // ָ豸									
									 PULONG			oReadLength,   // ָ򳤶ȵԪ,غΪʵʶȡֽڳ
									 PVOID			oReadBuffer ); // ָһ㹻Ļ,ڱȡ

//JTAG IRд,ֽΪλ,ֽд
//״̬:Run-Test->Shift-IR..->Exit IR -> Run-Test
BOOL	WINAPI	CH347Jtag_ByteWriteIR(ULONG			iIndex,        // ָ豸									
									  ULONG			iWriteLength,  // д,׼дֽڳ
									  PVOID			iWriteBuffer); // ָһ,׼д										

//JTAG IR,ֽΪλ,ֽд
//״̬:Run-Test->Shift-IR..->Exit IR -> Run-Test
BOOL	WINAPI	CH347Jtag_ByteReadIR(ULONG			iIndex,         // ָ豸									
									 PULONG			oReadLength,    // ָ򳤶ȵԪ,غΪʵʶȡֽڳ
									 PVOID			oReadBuffer );  // ָһ㹻Ļ,ڱȡ

//λʽJTAG DRд.ݵĶдָ״̬лȿഫ䡣ݴ䣬ʹUSB20Jtag_ByeWriteDR
//״̬:Run-Test->Shift-DR..->Exit DR -> Run-Test
BOOL	WINAPI	CH347Jtag_BitWriteDR(ULONG			iIndex,             // ָ豸									
									 ULONG    	    iWriteBitLength,    // ָ򳤶ȵԪ,غΪʵʶȡֽڳ
									 PVOID			iWriteBitBuffer );  // ָһ㹻Ļ,ڱȡ

//λʽJTAG IRд.ݵĶдָ״̬лȿഫ䡣ݴ䣬ʹUSB20Jtag_ByteWriteIR
//״̬:Run-Test->Shift-IR..->Exit IR -> Run-Test
BOOL	WINAPI	CH347Jtag_BitWriteIR(ULONG			iIndex,             // ָ豸									
									 ULONG    	    iWriteBitLength,    // ָ򳤶ȵԪ,غΪʵʶȡֽڳ
									 PVOID			iWriteBitBuffer );  // ָһ㹻Ļ,ڱȡ

//λʽJTAG IRݶ.ݵĶдָ״̬лȡݴ䣬ʹUSB20Jtag_ByteReadIR
//״̬:Run-Test->Shift-IR..->Exit IR -> Run-Test
BOOL	WINAPI	CH347Jtag_BitReadIR(ULONG			iIndex,				// ָ豸									
									PULONG    	oReadBitLength,			// ָ򳤶ȵԪ,غΪʵʶȡֽڳ
									PVOID			oReadBitBuffer );	// ָһ㹻Ļ,ڱȡ

//λʽJTAG DRݶ.ݵĶд͸ݴ䣬ʹUSB20Jtag_ByteReadDR
//״̬:Run-Test->Shift-DR..->Exit DR -> Run-Test
BOOL	WINAPI	CH347Jtag_BitReadDR(ULONG			iIndex,				// ָ豸									
									PULONG    	oReadBitLength,			// ָ򳤶ȵԪ,غΪʵʶȡֽڳ
									PVOID			oReadBitBuffer );   // ָһ㹻Ļ,ڱȡ

//ȡCH347GPIOŵƽֵ
BOOL WINAPI CH347GPIO_Get(ULONG iIndex,
						  UCHAR *iDir,        //ŷ:GPIO0-7Ӧλ0-7.0룻1
						  UCHAR *iData);      //GPIO0ƽ:GPIO0-7Ӧλ0-7,0͵ƽ1ߵƽ)

//CH347GPIOŵƽֵ
BOOL WINAPI CH347GPIO_Set(ULONG iIndex,
						  UCHAR iEnable,       //Ч־:Ӧλ0-7,ӦGPIO0-7.
						  UCHAR iSetDirOut,    //I/O,ĳλ0ӦΪ,ĳλ1ӦΪ.GPIO0-7Ӧλ0-7.
						  UCHAR iSetDataOut);   //,I/OΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ

//IAP̼ģʽ
BOOL	WINAPI	CH347StartIapFwUpate(ULONG    iIndex,
									 ULONG	  FwSize); // ̼

/**************HID/VCP**********************/
//򿪴
HANDLE WINAPI CH347Uart_Open(ULONG iIndex);

//رմ
BOOL WINAPI CH347Uart_Close(ULONG iIndex);

BOOL	WINAPI	CH347Uart_SetDeviceNotify(												// 趨豸¼֪ͨ
										  ULONG					iIndex,					// ָ豸,0Ӧһ豸
										  PCHAR					iDeviceID,				// ѡ,ַָ,ָص豸ID,ַ\0ֹ
										  mPCH347_NOTIFY_ROUTINE	iNotifyRoutine );   // ָ豸¼ص,ΪNULLȡ¼֪ͨ,ڼ⵽¼ʱøó

//ȡUARTӲ
BOOL    WINAPI  CH347Uart_GetCfg(ULONG   iIndex,       // ָ豸
								 PULONG  BaudRate,     // 
								 PUCHAR  ByteSize,     // λ(5,6,7,8,16)
								 PUCHAR  Parity,       // Уλ(0None; 1Odd; 2Even; 3Mark; 4Space)
								 PUCHAR  StopBits,     // ֹͣλ(01ֹͣλ; 11.5ֹͣλ; 22ֹͣλ)
								 PUCHAR  ByteTimeout); //ֽڳʱ

//UART								   
BOOL  WINAPI   CH347Uart_Init(ULONG  iIndex,      // ָ豸
							  DWORD  BaudRate,    // 
							  UCHAR  ByteSize,    // λ(5,6,7,8,16)
							  UCHAR  Parity,      // Уλ(0None; 1Odd; 2Even; 3Mark; 4Space)
							  UCHAR  StopBits,    // ֹͣλ(01ֹͣλ; 11.5ֹͣλ; 22ֹͣλ)
							  UCHAR  ByteTimeout);// ֽڳʱʱ,λ100uS

// USBݶдĳʱ
BOOL	WINAPI	CH347Uart_SetTimeout(ULONG			iIndex,         // ָ豸
									 ULONG			iWriteTimeout,  // ָUSBдݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
									 ULONG			iReadTimeout ); // ָUSBȡݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)

// ȡݿ
BOOL  WINAPI   CH347Uart_Read(ULONG			iIndex,    // ָ豸
							  PVOID			oBuffer,   // ָһ㹻Ļ,ڱȡ
							  PULONG		ioLength );// ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

// дݿ
BOOL  WINAPI   CH347Uart_Write(ULONG		iIndex,    // ָ豸
							   PVOID		iBuffer,   // ָһ,׼д
							   PULONG		ioLength );// ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

//ѯжֽδȡ
BOOL WINAPI CH347Uart_QueryBufUpload(ULONG			iIndex,    // ָ豸
									 LONGLONG       *RemainBytes);

//ȡ豸Ϣ
BOOL WINAPI CH347Uart_GetDeviceInfor(ULONG iIndex,mDeviceInforS *DevInformation);


/********IIC***********/
// ôģʽ
BOOL	WINAPI	CH347I2C_Set(ULONG			iIndex,  // ָ豸
							 ULONG			iMode );  // ָģʽ,
// λ1-λ0: I2Cӿٶ/SCLƵ, 00=/20KHz,01=׼/100KHz(Ĭֵ),10=/400KHz,11=/750KHz
// ,Ϊ0

// Ӳ첽ʱ,úܿ췵,һ֮ǰʱָ
BOOL	WINAPI	CH347I2C_SetDelaymS(ULONG			iIndex,       // ָ豸
									ULONG			iDelay ) ;    // ָʱĺ

 // I2C,2߽ӿ,ʱΪSCL,ΪSDA
BOOL	WINAPI	CH347StreamI2C( ULONG			iIndex,        // ָ豸
							    ULONG			iWriteLength,  // ׼дֽ
							    PVOID			iWriteBuffer,  // ָһ,׼д,ֽͨI2C豸ַдλ
							    ULONG			iReadLength,   // ׼ȡֽ
							    PVOID			oReadBuffer ); // ָһ,غǶ
#ifndef _CH341_DLL_H
typedef	enum	_EEPROM_TYPE {// EEPROMͺ
	ID_24C01,
	ID_24C02,
	ID_24C04,
	ID_24C08,
	ID_24C16,
	ID_24C32,
	ID_24C64,
	ID_24C128,
	ID_24C256,
	ID_24C512,
	ID_24C1024,
	ID_24C2048,
	ID_24C4096
} EEPROM_TYPE;
#endif

// EEPROMжȡݿ,ٶԼ56Kֽ
BOOL	WINAPI	CH347ReadEEPROM(ULONG			iIndex,     // ָ豸
								EEPROM_TYPE		iEepromID,  // ָEEPROMͺ
								ULONG			iAddr,      // ָݵԪĵַ
								ULONG			iLength,    // ׼ȡֽ
								PUCHAR			oBuffer );  // ָһ,غǶ
// EEPROMдݿ
BOOL	WINAPI	CH347WriteEEPROM(ULONG			iIndex,     // ָ豸
								 EEPROM_TYPE	iEepromID,  // ָEEPROMͺ
								 ULONG			iAddr,      // ָݵԪĵַ
								 ULONG			iLength,    // ׼дֽ
								 PUCHAR			iBuffer );  // ָһ,׼д

#ifdef __cplusplus
}
#endif

#endif		// _CH347_DLL_H
